/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.common.waypoint;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class WaypointFactoryImpl
implements WaypointFactory.WaypointStore {
    public static WaypointFactoryImpl instance;
    public static WaypointFactory factory;

    public static void init() {
        instance = new WaypointFactoryImpl();
        factory = new WaypointFactory((WaypointFactory.WaypointStore)instance);
    }

    public static Waypoint createWaypoint(String modId, class_2338 blockPos, String name, String dimension, boolean showDeviation) {
        return WaypointFactoryImpl.createWaypoint(modId, blockPos, name, dimension, false, showDeviation, RGB.randomColor(), true);
    }

    public static Waypoint createWaypoint(String modId, class_2338 blockPos, String name, String dimension, int color) {
        return WaypointFactoryImpl.createWaypoint(modId, blockPos, name, dimension, false, false, color, true);
    }

    public Waypoint createClientWaypoint(String modId, class_2338 pos, @Nullable String name, String primaryDimension, boolean persistent) {
        return WaypointFactoryImpl.createWaypoint(modId, pos, name, primaryDimension, false, persistent);
    }

    public WaypointGroup createWaypointGroup(String modId, String name) {
        return new WaypointGroupImpl(modId, name);
    }

    public WaypointGroup createWaypointGroup(String name) {
        return this.createWaypointGroup("journeymap", name);
    }

    public static Waypoint createWaypoint(String modId, class_2338 pos, @Nullable String name, String primaryDimension, boolean isDeath, boolean persistent) {
        return WaypointFactoryImpl.createWaypoint(modId, pos, name, primaryDimension, isDeath, false, RGB.randomColor(), persistent);
    }

    public static Waypoint createWaypoint(String modId, class_2338 blockPos, @Nullable String name, String primaryDimension, boolean isDeath, boolean showDeviation, int color, boolean persistent) {
        String guid = UUID.randomUUID().toString();
        if (name == null) {
            name = WaypointFactoryImpl.createName(blockPos.method_10263(), blockPos.method_10260());
        }
        class_2960 icon = isDeath ? WaypointIcon.DEFAULT_ICON_DEATH : WaypointIcon.DEFAULT_ICON_NORMAL;
        String group = isDeath ? WaypointGroupStore.DEATH.getGuid() : WaypointGroupStore.DEFAULT.getGuid();
        return new ClientWaypointImpl(name, "1", modId, guid, modId, group, new WaypointPos(blockPos, primaryDimension), color, new WaypointIcon(icon), new WaypointSettings(true, showDeviation, persistent), new TreeSet<String>(Set.of(primaryDimension)), Optional.empty());
    }

    public static Waypoint createCommandWaypoint(String modId, class_2338 blockPos, @Nullable String name, String primaryDimension, boolean isDeath, boolean showDeviation, int color, boolean persistent) {
        String guid = UUID.randomUUID().toString();
        if (name == null) {
            name = WaypointFactoryImpl.createName(blockPos.method_10263(), blockPos.method_10260());
        }
        class_2960 icon = isDeath ? WaypointIcon.DEFAULT_ICON_DEATH : WaypointIcon.DEFAULT_ICON_NORMAL;
        String group = "journeymap_default";
        return new WaypointImpl(name, "1", modId, guid, modId, group, new WaypointPos(blockPos, primaryDimension), color, new WaypointIcon(icon), new WaypointSettings(true, showDeviation, persistent), new TreeSet<String>(Set.of(primaryDimension)), Optional.empty());
    }

    public static void createDeathPoint(class_2338 blockPos, String dimension) {
        Date now = new Date();
        WaypointProperties properties = JourneymapClient.getInstance().getWaypointProperties();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(properties.timeFormat.get() + " " + properties.dateFormat.get());
        String timeDate = simpleDateFormat.format(now);
        String name = String.format("%s %s", Constants.getString("jm.waypoint.deathpoint"), timeDate);
        Waypoint waypoint = WaypointFactoryImpl.createWaypoint("journeymap", blockPos, name, dimension, true, true);
        WaypointStore.getInstance().save((ClientWaypointImpl)waypoint, false);
    }

    public static ClientWaypointImpl at(class_2338 blockPos, boolean isDeath, String dimension) {
        return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", blockPos, WaypointFactoryImpl.createName(blockPos.method_10263(), blockPos.method_10260()), dimension, isDeath, true);
    }

    private static String createName(int x, int z) {
        return String.format("%s, %s", x, z);
    }

    public static ClientWaypointImpl of(class_746 player) {
        class_2338 blockPos = new class_2338(class_3532.method_15357((double)player.method_23317()), class_3532.method_15357((double)player.method_23318()), class_3532.method_15357((double)player.method_23321()));
        return WaypointFactoryImpl.at(blockPos, false, class_310.method_1551().field_1724.method_5770().method_27983().method_29177().toString());
    }
}

