/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockDataArrays;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.MapType;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    protected final WeakReference<class_2818> chunkReference;
    private final class_1923 coord;
    private final HashMap<String, Serializable> properties = new HashMap();
    private BlockDataArrays blockDataArrays = new BlockDataArrays();
    private final Random random;
    protected class_2818 retainedChunk;
    private byte[][][][] lights;

    public ChunkMD(class_2818 chunk) {
        this(chunk, false);
    }

    public ChunkMD(class_2818 chunk, boolean forceRetain, byte[][][][] lights) {
        this(chunk, forceRetain);
        this.lights = lights;
    }

    public ChunkMD(class_2818 chunk, boolean forceRetain) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.random = new Random();
        this.coord = new class_1923(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(ChunkMD.isSlimeChunk(chunk)));
        this.chunkReference = new WeakReference<class_2818>(chunk);
        if (forceRetain) {
            this.retainedChunk = chunk;
        }
    }

    public class_2680 getBlockState(int localX, int y, int localZ) {
        if (localX < 0 || localX > 15 || localZ < 0 || localZ > 15) {
            Journeymap.getLogger().warn("Expected local coords, got global coords");
        }
        return this.getBlockState(new class_2338(this.toWorldX(localX), y, this.toWorldZ(localZ)));
    }

    public class_2680 getChunkBlockState(class_2338 blockPos) {
        return this.getChunk().method_8320(blockPos);
    }

    public class_2680 getBlockState(class_2338 blockPos) {
        return JmBlockAccess.INSTANCE.method_8320(blockPos);
    }

    public BlockMD getBlockMD(class_2338 blockPos) {
        return BlockMD.getBlockMD(this, blockPos);
    }

    @Nullable
    public class_6880<class_1959> getBiomeHolder(class_2338 pos) {
        return this.getChunk().method_16359(pos.method_10263() >> 2, pos.method_10264() >> 2, pos.method_10260() >> 2);
    }

    @Nullable
    public class_1959 getBiome(class_2338 pos) {
        class_6880<class_1959> holder = this.getBiomeHolder(pos);
        return holder != null ? (class_1959)holder.comp_349() : null;
    }

    public class_5321<class_1959> getBiomeKey(class_2338 pos) {
        class_6880<class_1959> holder = this.getBiomeHolder(pos);
        if (holder != null) {
            Optional key = holder.method_40230();
            return key.orElse(class_1972.field_9451);
        }
        return class_1972.field_9451;
    }

    public int getSavedLightValue(int localX, int y, int localZ) {
        if (this.lights != null) {
            try {
                int localY = class_4076.method_18684((int)y);
                int sectionIndex = this.getChunk().method_12200().method_31602(y);
                byte light = this.lights[sectionIndex][localX][localY][localZ];
                return light;
            }
            catch (Exception localY) {
                // empty catch block
            }
        }
        try {
            return this.getChunk().method_12200().method_22336().method_15562(class_1944.field_9282).method_15543(this.getBlockPos(localX, y, localZ));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    public BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.getBlockMD(this, this.getBlockPos(localX, y, localZ));
    }

    public int ceiling(int localX, int localZ) {
        int y = this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
        class_2338 blockPos = null;
        try {
            while (y >= this.getMinY()) {
                blockPos = this.getBlockPos(localX, y, localZ);
                BlockMD blockMD = this.getBlockMD(blockPos);
                if (blockMD == null) {
                    --y;
                    continue;
                }
                if (blockMD.isIgnore() || blockMD.hasFlag(BlockFlag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (this.canBlockSeeTheSky(localX, y, localZ)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.valueOf(e) + " at " + String.valueOf(blockPos), (Throwable)e);
        }
        return Math.max(this.getMinY(), y);
    }

    public boolean hasChunk() {
        class_2818 chunk = (class_2818)this.chunkReference.get();
        boolean result = chunk != null && !(chunk instanceof class_2812);
        return result;
    }

    public int getHeight(class_2338 blockPos) {
        return this.getPrecipitationHeight(blockPos);
    }

    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
    }

    public int getPrecipitationHeight(class_2338 blockPos) {
        if (!JourneymapClient.getInstance().getCoreProperties().ignoreHeightmaps.get().booleanValue()) {
            return this.getChunk().method_12005(class_2902.class_2903.field_13202, blockPos.method_10263(), blockPos.method_10260());
        }
        return this.getChunk().method_31600();
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        return blockMD.getBlockState().method_26193();
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public class_2818 getChunk() {
        class_2818 chunk = (class_2818)this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public class_638 getWorld() {
        class_310 mc = class_310.method_1551();
        try {
            return mc.field_1724 == null ? mc.field_1687 : mc.field_1724.field_17892;
        }
        catch (Throwable t) {
            return mc.field_1687;
        }
    }

    public int getWorldActualHeight() {
        return this.getWorld().method_8597().comp_653() + 1;
    }

    public Boolean hasNoSky() {
        return !this.getWorld().method_8597().comp_645();
    }

    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        int i = localX & 0xF;
        int k = localZ & 0xF;
        if (this.lights != null) {
            return this.getSavedLightValue(localX, y, localZ) > 0;
        }
        return this.getChunk().method_12200().method_8311(this.getBlockPos(localX, y, localZ));
    }

    public class_1923 getCoord() {
        return this.coord;
    }

    public static boolean isSlimeChunk(class_2818 chunk) {
        if (chunk.method_12200() instanceof class_3218) {
            return class_2919.method_12662((int)chunk.method_12004().field_9181, (int)chunk.method_12004().field_9180, (long)((class_3218)chunk.method_12200()).method_8412(), (long)987234911L).method_43048(10) == 0;
        }
        return false;
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public void resetRenderTimes() {
        this.getRenderTimes().clear();
    }

    public void resetRenderTime(MapType mapType) {
        this.getRenderTimes().put(mapType, 0L);
    }

    public void resetBlockData(MapType mapType) {
        this.getBlockData().get(mapType).clear();
    }

    protected HashMap<MapType, Long> getRenderTimes() {
        HashMap obj = this.properties.get(PROP_LAST_RENDERED);
        if (!(obj instanceof HashMap)) {
            obj = new HashMap();
            this.properties.put(PROP_LAST_RENDERED, obj);
        }
        return obj;
    }

    public long getLastRendered(MapType mapType) {
        return this.getRenderTimes().getOrDefault(mapType, 0L);
    }

    public long setRendered(MapType mapType) {
        long now = System.currentTimeMillis();
        this.getRenderTimes().put(mapType, now);
        return now;
    }

    public class_2338 getBlockPos(int localX, int y, int localZ) {
        return new class_2338(this.toWorldX(localX), y, this.toWorldZ(localZ));
    }

    public int toWorldX(int localX) {
        return (this.coord.field_9181 << 4) + localX;
    }

    public int toWorldZ(int localZ) {
        return (this.coord.field_9180 << 4) + localZ;
    }

    public BlockDataArrays getBlockData() {
        return this.blockDataArrays;
    }

    public BlockDataArrays.DataArray<Integer> getBlockDataInts(MapType mapType) {
        return this.blockDataArrays.get(mapType).ints();
    }

    public BlockDataArrays.DataArray<Float> getBlockDataFloats(MapType mapType) {
        return this.blockDataArrays.get(mapType).floats();
    }

    public BlockDataArrays.DataArray<Boolean> getBlockDataBooleans(MapType mapType) {
        return this.blockDataArrays.get(mapType).booleans();
    }

    public String toString() {
        return "ChunkMD{coord=" + String.valueOf(this.coord) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public class_5321<class_1937> getDimension() {
        return this.getWorld().method_27983();
    }

    public void stopChunkRetention() {
        this.retainedChunk = null;
    }

    public boolean hasRetainedChunk() {
        return this.retainedChunk != null;
    }

    public Integer getMinY() {
        return this.getWorld().method_31607();
    }

    public boolean fromNbt() {
        return false;
    }

    public long getLongCoord() {
        return this.coord.method_8324();
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(class_1923 coord) {
            super("Chunk missing: " + String.valueOf(coord));
        }
    }
}

