/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.client.ui.waypointmanager.waypoint.DeleteConfirmWaypointPopup;
import journeymap.client.ui.waypointmanager.waypoint.DimensionPanel;
import journeymap.client.ui.waypointmanager.waypoint.DimensionSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class WaypointEditor
extends PopupButtonScreen<Waypoint>
implements SelectableParent {
    private TextBox nameTextBox;
    private TextBox xLocTextBox;
    private TextBox yLocTextBox;
    private TextBox zLocTextBox;
    private TextBox zyzLocTextBox;
    private boolean enabled;
    private int color;
    private DropDownButton iconDropDown;
    private DropDownButton groupDropDown;
    private List<DimensionSlot> dimensionSlots;
    private List<DropDownItem> iconDropDownItems;
    private List<DropDownItem> groupDropDownItems;
    private DimensionPanel<DimensionSlot> dimensionPanel;
    private DimensionSlot primarySlot;
    private class_8667 layout = class_8667.method_52741();
    private class_8667 editorLayout;
    private ClientWaypointImpl waypoint;
    private final class_1043 question = TextureCache.getTexture(TextureCache.Question);
    private WaypointGroup group;
    private boolean isNewWaypoint = false;
    private boolean openedWithHotkey = false;

    public WaypointEditor(ClientWaypointImpl waypoint) {
        this((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_title"), waypoint, null);
    }

    public WaypointEditor(boolean openedWithHotkey, @Nullable class_2338 pos) {
        this((class_2561)class_2561.method_43471((String)"jm.waypoint.new_title"), null, pos);
        this.openedWithHotkey = openedWithHotkey;
    }

    public WaypointEditor(class_2561 title, @Nullable ClientWaypointImpl waypoint, @Nullable class_2338 pos) {
        super(title);
        this.isNewWaypoint = waypoint == null;
        this.waypoint = waypoint != null ? (ClientWaypointImpl)WaypointHandler.getInstance().getDao().copyWaypoint(waypoint) : this.buildNewWaypoint(pos);
    }

    public WaypointEditor(boolean openedWithHotkey, ClientWaypointImpl waypoint, WaypointGroup group) {
        this(false, null);
        this.group = group;
    }

    private ClientWaypointImpl buildNewWaypoint(@Nullable class_2338 pos) {
        class_746 player = class_310.method_1551().field_1724;
        return (ClientWaypointImpl)WaypointFactory.createClientWaypoint((String)"journeymap", (class_2338)(pos == null ? player.method_24515() : pos), (class_5321)player.method_37908().method_27983(), (boolean)true);
    }

    public void renderPopupScreenBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        guiGraphics.method_52706(class_1921::method_62277, BACKGROUND_SPRITE, this.editorLayout.method_46426() - 18, this.editorLayout.method_46427() - 18, this.editorLayout.method_25368() + 36, this.editorLayout.method_25364() + 36);
    }

    protected void renderPopupScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        Optional child = this.dimensionPanel.method_19355(mouseX, mouseY);
        if (child.isPresent()) {
            List lastTooltip = this.dimensionPanel.lastTooltip;
            long lastTooltipTime = this.dimensionPanel.lastTooltipTime;
            if (this.dimensionPanel.lastTooltip != null && this.dimensionPanel.lastTooltip.equals(lastTooltip)) {
                this.dimensionPanel.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.dimensionPanel.lastTooltipTime > this.dimensionPanel.hoverDelay) {
                    graphics.method_51447(this.field_22793, this.dimensionPanel.lastTooltip, mouseX, mouseY + 15);
                }
            }
        }
    }

    protected void method_25426() {
        this.dimensionSlots = this.buildDimensionSlots();
        this.dimensionPanel = new DimensionPanel(this.minecraft, 0, 0, 20);
        this.iconDropDownItems = this.buildIconDropdownItems();
        this.groupDropDownItems = this.buildGroupDropdownItems();
        this.enabled = this.waypoint.isEnabled();
        this.setColor(this.waypoint.getIconColor());
        this.layout.method_52735(6);
        this.editorLayout = class_8667.method_52742();
        this.layout.method_52736((class_8021)this.editorLayout);
        class_8667 editTab = (class_8667)this.editorLayout.method_52736((class_8021)this.editTab());
        this.editorLayout.method_52736((class_8021)this.dimensionsLayout());
        this.editorLayout.method_52735(12);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.dimensionPanel.setSlots(this.dimensionSlots);
        this.dimensionPanel.initSlots();
        this.dimensionPanel.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.method_48640();
        this.method_48265((class_364)this.nameTextBox);
    }

    protected void method_48640() {
        this.layout.method_48222();
        this.dimensionPanel.repositionSlots();
        this.dimensionPanel.updateSize(120, this.layout.method_25364() - 20, 0, 0);
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DimensionSlot dimSlot;
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (button == 0 && (dimSlot = (DimensionSlot)this.dimensionPanel.method_25334()) != null && this.dimensionPanel.method_25405(mouseX, mouseY)) {
            if (dimSlot.isPrimary() && !dimSlot.getDimId().equals(this.primarySlot != null ? this.primarySlot.getDimId() : null)) {
                this.dimensionPanel.getRootSlots().forEach(slot -> slot.setPrimary(false));
                dimSlot.setPrimary(true);
                this.primarySlot = dimSlot;
            }
            if (!this.dimensionPanel.getRootSlots().stream().anyMatch(DimensionSlot::isPrimary)) {
                this.primarySlot.setPrimary(true);
            }
        }
        return clicked;
    }

    private class_8667 dimensionsLayout() {
        int size = 10;
        class_8667 layout = class_8667.method_52741();
        class_8667 topLayout = class_8667.method_52742();
        topLayout.method_52735(4);
        layout.method_52735(6);
        topLayout.method_52736((class_8021)new StringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.dimensions").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793));
        ColoredImageWidget image = (ColoredImageWidget)topLayout.method_52736((class_8021)ColoredImageWidget.texture(size, size, this.question, size, size, 65535, true));
        image.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.dimensions.question.tooltip")));
        layout.method_52738((class_8021)topLayout, class_7847::method_46467);
        layout.method_52736(this.dimensionPanel);
        return layout;
    }

    private class_8667 editTab() {
        class_8667 layout = class_8667.method_52741();
        class_8667 topLayout = class_8667.method_52742();
        layout.method_52738((class_8021)new StringWidget((class_2561)this.method_25440().method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), class_7847::method_46467);
        layout.method_52736((class_8021)topLayout);
        layout.method_52735(4);
        topLayout.method_52735(4);
        topLayout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.name").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), class_7847::method_46476);
        topLayout.method_52736((class_8021)new class_7852(30, 20));
        this.groupDropDown = (DropDownButton)topLayout.method_52738((class_8021)new DropDownButton("", this::onGroupSelectDropDown), class_7847::method_46474);
        this.groupDropDown.setItems(this.groupDropDownItems);
        this.groupDropDown.setDefaultStyle(false);
        this.groupDropDown.setDrawBackground(false);
        if (this.group != null && !this.group.getGuid().equals(WaypointGroupStore.ALL.getGuid())) {
            if (this.group.isLocked() && !this.group.getGuid().equals(WaypointGroupStore.TEMP.getGuid())) {
                this.groupDropDown.setSelectedId(WaypointGroupStore.DEFAULT.getGuid());
            } else {
                this.groupDropDown.setSelectedId(this.group.getGuid());
            }
        } else {
            this.groupDropDown.setSelectedId(this.waypoint.getGroupId());
        }
        this.groupDropDown.setRenderSolidBackground(true);
        PopupButton createGroupButton = (PopupButton)topLayout.method_52738(new PopupButton<WaypointGroup>(0, 0, "+", () -> new EditGroupPopup((class_2561)class_2561.method_43471((String)"jm.waypoint.group.new_group.label")), this::addNewGroup), class_7847::method_46474);
        createGroupButton.method_25355((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1077));
        createGroupButton.method_55445(12, 12);
        createGroupButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.group.new_group.label")));
        this.nameTextBox = (TextBox)layout.method_52736((class_8021)new TextBox(this.waypoint.getName(), this.field_22793, 222, 20));
        class_7845 locGridLayout = new class_7845();
        locGridLayout.method_48635(6);
        locGridLayout.method_48636(4);
        layout.method_52736((class_8021)locGridLayout);
        locGridLayout.method_46452((class_8021)new StringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.x").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), 0, 0);
        this.xLocTextBox = (TextBox)locGridLayout.method_46452((class_8021)new TextBox(this.waypoint.getRawX(), this.field_22793, 70, 20, true, true), 1, 0);
        locGridLayout.method_46452((class_8021)new StringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.z").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), 0, 1);
        locGridLayout.method_46452((class_8021)new StringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.y").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), 0, 2);
        this.zLocTextBox = (TextBox)locGridLayout.method_46452((class_8021)new TextBox(this.waypoint.getRawZ(), this.field_22793, 70, 20, true, true), 1, 1);
        this.yLocTextBox = (TextBox)locGridLayout.method_46452((class_8021)new TextBox(this.waypoint.getY(), this.field_22793, 70, 20, true, true), 1, 2);
        this.nameTextBox.setMinLength(1);
        this.xLocTextBox.setMinLength(1);
        this.yLocTextBox.setMinLength(1);
        this.zLocTextBox.setMinLength(1);
        class_8667 colorLayout = class_8667.method_52742();
        colorLayout.method_52735(10);
        layout.method_52738((class_8021)colorLayout, class_7847::method_46467);
        colorLayout.method_52738((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.randomize"), this::randomColor).method_46432(20 + this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"jm.waypoint.randomize"))).method_46431(), class_7847::method_46474);
        this.iconDropDown = (DropDownButton)colorLayout.method_52738((class_8021)new DropDownButton("", this::iconDropDown), class_7847::method_46474);
        this.iconDropDown.setItems(this.iconDropDownItems);
        this.iconDropDown.setDefaultStyle(false);
        this.iconDropDown.setDrawBackground(false);
        this.iconDropDown.setSelectedId(this.waypoint.getIconResourceLocation().toString().replace("ui/img", "textures/waypoint/icon"));
        this.iconDropDown.setRenderSolidBackground(true);
        colorLayout.method_52736((class_8021)new ColorPickerButton(20, 20, () -> this.waypoint.getRenderColor(), this::updateWaypointColor));
        class_8667 bottomOneLayout = class_8667.method_52742();
        class_8667 bottomTwoLayout = class_8667.method_52742();
        layout.method_52738((class_8021)bottomOneLayout, class_7847::method_46467);
        layout.method_52738((class_8021)bottomTwoLayout, class_7847::method_46467);
        bottomOneLayout.method_52735(4);
        bottomTwoLayout.method_52735(4);
        bottomOneLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43469((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}), this::toggle).method_46432(20 + this.field_22793.method_27525((class_5348)class_2561.method_43469((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}))).method_46431());
        bottomOneLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.reset"), this::reset).method_46432(20 + this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"jm.waypoint.reset"))).method_46431());
        PopupButton deleteButton = (PopupButton)bottomTwoLayout.method_52736(new PopupButton<Boolean>(20 + this.field_22793.method_1727(Constants.getString("jm.common.delete")), 0, Constants.getString("jm.common.delete"), () -> new DeleteConfirmWaypointPopup(this.waypoint), this::delete));
        if (this.isNewWaypoint) {
            deleteButton.setEnabled(false);
        }
        bottomTwoLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.save"), this::save).method_46432(20 + this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"jm.waypoint.save"))).method_46431());
        bottomTwoLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.cancel"), this::cancel).method_46432(20 + this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"jm.common.cancel"))).method_46431());
        return layout;
    }

    private void addNewGroup(WaypointGroup group) {
        if (!EventBus.post(new WaypointGroupEvent(group, WaypointGroupEvent.Context.CREATE)).isCancelled()) {
            if (this.backgroundScreen == null || !(this.backgroundScreen instanceof WaypointManager)) {
                WaypointGroupStore.getInstance().put(group);
            }
            this.groupDropDownItems = this.buildGroupDropdownItems();
            this.groupDropDown.setItems(this.groupDropDownItems);
        }
    }

    private void randomColor(class_4185 button) {
        this.setColor(RGB.randomColor());
    }

    private void setColor(int color) {
        this.color = color;
        this.iconDropDownItems.forEach(item -> ((ImageDropDownItem)((Object)item)).setColor(color));
    }

    private void toggle(class_4185 button) {
        this.enabled = !this.enabled;
        button.method_25355((class_2561)class_2561.method_43469((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}));
    }

    private void delete(boolean button) {
        EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.DELETED, null));
        this.method_25419();
    }

    private void save(class_4185 button) {
        if (!this.validateTextBoxes(this.nameTextBox, this.xLocTextBox, this.yLocTextBox, this.zLocTextBox)) {
            return;
        }
        this.waypoint.setName(this.nameTextBox.method_1882());
        this.waypoint.setX(Integer.parseInt(this.xLocTextBox.method_1882()));
        this.waypoint.setY(Integer.parseInt(this.yLocTextBox.method_1882()));
        this.waypoint.setZ(Integer.parseInt(this.zLocTextBox.method_1882()));
        if (this.iconDropDown != null && this.iconDropDown.getSelected() != null) {
            this.waypoint.getIcon().setResourceLoctaion(class_2960.method_60654((String)this.iconDropDown.getSelected().getId().toString()));
        }
        this.waypoint.setEnabled(this.enabled);
        this.waypoint.setColor(this.color);
        if (this.groupDropDown.getSelected() == null) {
            this.waypoint.setGroupId(WaypointGroupStore.DEFAULT.getGuid());
        } else {
            this.waypoint.setGroupId(this.groupDropDown.getSelected().getId().toString());
        }
        List<String> dims = this.dimensionSlots.stream().filter(DimensionSlot::isEnabled).map(DimensionSlot::getDimId).toList();
        this.waypoint.setDimensions(dims);
        Optional<DimensionSlot> primary = this.dimensionSlots.stream().filter(DimensionSlot::isEnabled).filter(DimensionSlot::isPrimary).findFirst();
        primary.ifPresent(dimensionSlot -> this.waypoint.setPrimaryDimension(dimensionSlot.getDimId()));
        if (!(EventBus.post(new WaypointEvent((Waypoint)this.waypoint, this.isNewWaypoint ? WaypointEvent.Context.CREATE : WaypointEvent.Context.UPDATE, null)).isCancelled() || this.backgroundScreen != null && this.backgroundScreen instanceof WaypointManager)) {
            WaypointStore.getInstance().save(this.waypoint, false, this.isNewWaypoint);
        }
        this.method_25419();
    }

    private boolean validateTextBoxes(TextBox ... textBoxes) {
        boolean valid = true;
        for (TextBox textBox : textBoxes) {
            String value = textBox.method_1882();
            if (value != null && !value.isEmpty() && textBox.hasMinLength()) continue;
            valid = false;
        }
        return valid;
    }

    private void cancel(class_4185 button) {
        this.method_25419();
    }

    private void reset(class_4185 button) {
        double scrollPos = this.dimensionPanel.method_44387();
        this.method_37067();
        this.layout = class_8667.method_52741();
        this.method_25426();
        this.dimensionPanel.method_44382(scrollPos);
    }

    private void updateWaypointColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.setColor(colorPickerResponse.color());
        }
    }

    private class_8667 tabs() {
        class_8667 layout = class_8667.method_52742();
        layout.method_52735(6);
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"Edit"), b -> this.tab()).method_46432(50).method_46431());
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"Server"), b -> this.tab()).method_46432(50).method_46431());
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"Options"), b -> this.tab()).method_46432(50).method_46431());
        return layout;
    }

    void tab() {
    }

    private List<DropDownItem> buildIconDropdownItems() {
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        if (!TextureCache.waypointIconMap.containsKey(this.waypoint.getIcon().getResourceLocation())) {
            class_2960 loc2 = this.waypoint.getIcon().getResourceLocation();
            class_1043 tex2 = TextureCache.getTexture(this.waypoint.getIcon().getResourceLocation());
            if (tex2 != null) {
                ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, (Object)loc2, tex2, 16, 16, this::onIconSelect, loc2.toString());
                icon.setColor(this.waypoint.getIconColor());
                list.add(icon);
            }
        }
        TextureCache.waypointIconMap.forEach((loc, tex) -> {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, loc, (class_1043)tex, 16, 16, this::onIconSelect, loc.toString());
            icon.setColor(this.waypoint.getIconColor());
            list.add(icon);
        });
        return list;
    }

    private List<DropDownItem> buildGroupDropdownItems() {
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        if (!this.waypoint.getGroup().isLocked()) {
            WaypointGroupStore.getInstance().getAll().forEach(group -> {
                if (!group.getGuid().equals(WaypointGroupStore.DEATH.getGuid()) && !group.getGuid().equals(WaypointGroupStore.ALL.getGuid())) {
                    list.add(new DropDownItem((SelectableParent)this, (Object)group.getGuid(), this.clipText(group.getName()), group.getName()));
                }
            });
        } else {
            list.add(new DropDownItem((SelectableParent)this, (Object)this.waypoint.getGroup().getGuid(), this.waypoint.getGroup().getName(), this.waypoint.getGroup().getName()));
        }
        return list;
    }

    private String clipText(String message) {
        int maxWidth = this.field_22793.method_1727("XXXXXXXXX");
        int width = this.field_22793.method_1727(message);
        class_327 font = class_310.method_1551().field_1772;
        if (width > maxWidth) {
            String formattedtext = font.method_27523(message, maxWidth - font.method_27525((class_5348)class_5244.field_39678));
            return formattedtext + "...";
        }
        return message;
    }

    private void onIconSelect(class_4185 button) {
    }

    private void iconDropDown(class_4185 button) {
    }

    @Override
    public void setSelected(DropDownItem button) {
        if (button instanceof ImageDropDownItem) {
            ImageDropDownItem imgButton = (ImageDropDownItem)button;
            this.iconDropDown.setSelected(imgButton);
        } else {
            this.groupDropDown.setSelected(button);
        }
    }

    private void onGroupSelectDropDown(class_4185 button) {
    }

    private List<DimensionSlot> buildDimensionSlots() {
        ArrayList<DimensionSlot> list = new ArrayList<DimensionSlot>();
        for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.getInstance().getLoadedDimensions())) {
            String dimName = WorldData.getSafeDimensionName(provider);
            String dimId = provider.getDimensionId();
            try {
                dimName = provider.getName();
            }
            catch (Exception e) {
                JMLogger.throwLogOnce("Can't get dimension name from provider: ", e);
            }
            DimensionSlot slot = new DimensionSlot(dimId, dimName, this.waypoint.getDimensions().contains(dimId), this.waypoint.getPrimaryDimension().equals(provider.getDimensionId()));
            if (slot.isPrimary()) {
                this.primarySlot = slot;
            }
            list.add(slot);
        }
        return list;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.openedWithHotkey && this.isNewWaypoint) {
            this.openedWithHotkey = false;
            return true;
        }
        return super.method_25400(typedChar, keyCode);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.save(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

