/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import journeymap.api.services.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class DimensionHelper {
    public static String getDimName(class_1297 entity) {
        return DimensionHelper.getDimName(entity.method_5770());
    }

    public static String getDimName(@Nullable class_1937 world) {
        if (world != null) {
            return DimensionHelper.getDimName((class_5321<class_1937>)world.method_27983());
        }
        return "overworld";
    }

    public static String getDimName(class_5321<class_1937> dimensionKey) {
        return dimensionKey.method_29177().method_12832();
    }

    public static String getDimName(String key) {
        return key.split(":")[1];
    }

    public static String getDimKeyName(class_1297 entity) {
        return DimensionHelper.getDimKeyName(entity.method_5770());
    }

    public static String getDimKeyName(@Nullable class_1937 world) {
        if (world != null) {
            return DimensionHelper.getDimKeyName((class_5321<class_1937>)world.method_27983());
        }
        return "minecraft:overworld";
    }

    public static String getDimKeyName(class_5321<class_1937> dimensionKey) {
        return dimensionKey.method_29177().toString();
    }

    public static class_5321<class_1937> getDimension(class_1297 entity) {
        return DimensionHelper.getDimension(entity.method_5770());
    }

    public static class_5321<class_1937> getDimension(class_1937 world) {
        return world.method_27983();
    }

    public static class_2874 getDimTypeForName(String dimName) {
        return DimensionHelper.getDimTypeMap().get(dimName);
    }

    public static class_2874 getDimTypeForKey(class_5321<class_1937> dimKey) {
        return DimensionHelper.getDimTypeMap().get(DimensionHelper.getDimName(dimKey));
    }

    public static String getSafeDimName(class_5321<class_1937> dim) {
        return dim.method_29177().toString().replaceAll(":", "~");
    }

    public static class_2960 getDimResource(String dimName) {
        return class_2960.method_60654((String)dimName);
    }

    public static boolean isNetherWorld(class_1937 world) {
        return world.method_27983().equals(class_1937.field_25180);
    }

    public static boolean isOverworldWorld(class_1937 world) {
        return world.method_27983().equals(class_1937.field_25179);
    }

    public static boolean isEndWorld(class_1937 world) {
        return world.method_27983().equals(class_1937.field_25181);
    }

    public static class_5321<class_1937> getWorldKeyForName(String dimName) {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionHelper.getDimResource(dimName));
    }

    public static Map<String, class_2874> getDimTypeMap() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Services.COMMON_SERVICE.getServer().method_3738().iterator(), 16), false).collect(Collectors.toMap(DimensionHelper::getDimKeyName, class_1937::method_8597));
    }

    public static List<class_5321<class_1937>> getServerDimNameList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Services.COMMON_SERVICE.getServer().method_3738().iterator(), 16), false).map(class_1937::method_27983).collect(Collectors.toList());
    }

    public static Set<class_5321<class_1937>> getClientDimList() {
        return class_310.method_1551().field_1724.field_3944.method_29356();
    }
}

