/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.widget.HoleWidget;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.joml.Matrix4f;

public class ScrollableViewWidget {
    public static WidgetWithBounds create(Rectangle bounds, WidgetWithBounds inner, boolean background) {
        return ScrollableViewWidget.create(bounds, inner, new ScrollingContainer[1], background);
    }

    public static WidgetWithBounds create(final Rectangle bounds, final WidgetWithBounds inner, ScrollingContainer[] scrollingRef, boolean background) {
        scrollingRef[0] = new ScrollingContainer(){

            public Rectangle getBounds() {
                return bounds;
            }

            public int getMaxScrollHeight() {
                return inner.getBounds().getHeight();
            }
        };
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        if (background) {
            widgets.add(HoleWidget.create(bounds));
        }
        widgets.add(Widgets.scissored(scrollingRef[0].getScissorBounds(), Widgets.withTranslate((Widget)inner, () -> new Matrix4f().translate(0.0f, (float)(-scrollingRef[0].scrollAmountInt()), 0.0f))));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            scrollingRef[0].updatePosition(delta);
            scrollingRef[0].renderScrollBar(graphics);
        }));
        widgets.add(ScrollableViewWidget.createScrollerWidget(bounds, scrollingRef[0]));
        return Widgets.concatWithBounds(bounds, widgets);
    }

    private static Widget createScrollerWidget(final Rectangle bounds, final ScrollingContainer scrolling) {
        return new Widget(){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (bounds.contains(mouseX, mouseY) && scrolling.updateDraggingState(mouseX, mouseY, button)) {
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                if (scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                    return true;
                }
                return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
            }

            public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
                if (bounds.contains(mouseX, mouseY) && amountY != 0.0) {
                    scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                    return true;
                }
                return super.method_25401(mouseX, mouseY, amountX, amountY);
            }
        };
    }
}

