/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.utils.PanelTextures;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;

public final class PanelWidget
extends Panel {
    private static final PanelWidget TEMP = new PanelWidget(new Rectangle());
    private Rectangle bounds;
    private int color = -1;
    private class_2960 texture;
    private class_2960 darkTexture;
    private Predicate<Panel> rendering = Predicates.alwaysTrue();
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public PanelWidget(Rectangle bounds) {
        this.bounds = Objects.requireNonNull(bounds);
        this.setTexture(PanelTextures.DEFAULT);
    }

    @Override
    public void setTexture(class_2960 texture, class_2960 darkTexture) {
        this.texture = texture;
        this.darkTexture = darkTexture;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public Predicate<Panel> getRendering() {
        return this.rendering;
    }

    @Override
    public void setRendering(Predicate<Panel> rendering) {
        this.rendering = Objects.requireNonNull(rendering);
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        if (ConfigUtils.isReducedMotion()) {
            this.darkBackgroundAlpha.completeImmediately();
        }
        if (!this.getRendering().test(this)) {
            return;
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderBackground(graphics, x, y, width, height, false, alpha, red, green, blue);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha > 0.0f) {
            this.renderBackground(graphics, x, y, width, height, true, ((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha, red, green, blue);
        }
    }

    public void renderBackground(class_332 graphics, int x, int y, int width, int height, boolean dark, float alpha, float red, float green, float blue) {
        class_2960 texture = dark ? this.darkTexture : this.texture;
        graphics.method_52707(class_1921::method_62277, texture, x, y, width, height, class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

