/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.zoomify;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.isxander.yacl3.config.v3.KotlinExtsKt;
import dev.isxander.zoomify.config.OverlayVisibility;
import dev.isxander.zoomify.config.SettingsGuiFactoryKt;
import dev.isxander.zoomify.config.SoundBehaviour;
import dev.isxander.zoomify.config.SpyglassBehaviour;
import dev.isxander.zoomify.config.ZoomKeyBehaviour;
import dev.isxander.zoomify.config.ZoomifySettings;
import dev.isxander.zoomify.config.migrator.Migrator;
import dev.isxander.zoomify.integrations.IntegrationHelperKt;
import dev.isxander.zoomify.utils.MinecraftExtKt;
import dev.isxander.zoomify.zoom.DefaultZoomHelpersKt;
import dev.isxander.zoomify.zoom.ZoomHelper;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u0003J\r\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003R\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010&R$\u0010+\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00128\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010\u001dR\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R$\u00101\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00128\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b1\u0010,\u001a\u0004\b2\u0010\u001dR\u0014\u00103\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00100R$\u00104\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0014\u00109\u001a\u0002088\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0016\u0010<\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010,R\u0016\u0010=\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010,\u00a8\u0006>"}, d2={"Ldev/isxander/zoomify/Zoomify;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lnet/minecraft/class_310;", "minecraft", "tick", "(Lnet/minecraft/class_310;)V", "", "tickDelta", "getZoomDivisor", "(F)F", "", "mouseDelta", "mouseZoom", "(D)V", "", "prevZooming", "handleSpyglass", "(Lnet/minecraft/class_310;Z)V", "Lnet/minecraft/class_742;", "player", "isUsingSpyglass", "shouldRenderOverlay", "(Lnet/minecraft/class_742;Z)Z", "onGameFinishedLoading", "unbindConflicting", "()Z", "detectConflictingToast", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "Lnet/minecraft/class_304;", "zoomKey", "Lnet/minecraft/class_304;", "secondaryZoomKey", "scrollZoomIn", "scrollZoomOut", "value", "zooming", "Z", "getZooming", "Ldev/isxander/zoomify/zoom/ZoomHelper;", "zoomHelper", "Ldev/isxander/zoomify/zoom/ZoomHelper;", "secondaryZooming", "getSecondaryZooming", "secondaryZoomHelper", "previousZoomDivisor", "D", "getPreviousZoomDivisor", "()D", "", "maxScrollTiers", "I", "scrollSteps", "shouldPlaySound", "displayGui", "Zoomify"})
@SourceDebugExtension(value={"SMAP\nZoomify.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zoomify.kt\ndev/isxander/zoomify/Zoomify\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,246:1\n1#2:247\n12574#3,2:248\n*S KotlinDebug\n*F\n+ 1 Zoomify.kt\ndev/isxander/zoomify/Zoomify\n*L\n235#1:248,2\n*E\n"})
public final class Zoomify
implements ClientModInitializer {
    @NotNull
    public static final Zoomify INSTANCE = new Zoomify();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final class_304 zoomKey;
    @NotNull
    private static final class_304 secondaryZoomKey;
    @NotNull
    private static final class_304 scrollZoomIn;
    @NotNull
    private static final class_304 scrollZoomOut;
    private static boolean zooming;
    @NotNull
    private static final ZoomHelper zoomHelper;
    private static boolean secondaryZooming;
    @NotNull
    private static final ZoomHelper secondaryZoomHelper;
    private static double previousZoomDivisor;
    public static final int maxScrollTiers = 30;
    private static int scrollSteps;
    private static boolean shouldPlaySound;
    private static boolean displayGui;

    private Zoomify() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final boolean getZooming() {
        return zooming;
    }

    public final boolean getSecondaryZooming() {
        return secondaryZooming;
    }

    public final double getPreviousZoomDivisor() {
        return previousZoomDivisor;
    }

    public void onInitializeClient() {
        IntegrationHelperKt.constrainModVersionIfLoaded("controlify", "2.x.x");
        KeyBindingHelper.registerKeyBinding((class_304)zoomKey);
        KeyBindingHelper.registerKeyBinding((class_304)secondaryZoomKey);
        if (ZoomifySettings.Companion.getKeybindScrolling()) {
            KeyBindingHelper.registerKeyBinding((class_304)scrollZoomIn);
            KeyBindingHelper.registerKeyBinding((class_304)scrollZoomOut);
        }
        ClientCommandRegistrationCallback.EVENT.register(Zoomify::onInitializeClient$lambda$1);
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
    }

    private final void tick(class_310 minecraft) {
        boolean prevZooming = zooming;
        switch (WhenMappings.$EnumSwitchMapping$0[((ZoomKeyBehaviour)KotlinExtsKt.getValue(ZoomifySettings.Companion.getZoomKeyBehaviour())).ordinal()]) {
            case 1: {
                zooming = zoomKey.method_1434();
                break;
            }
            case 2: {
                while (zoomKey.method_1436()) {
                    zooming = !zooming;
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        while (secondaryZoomKey.method_1436()) {
            secondaryZooming = !secondaryZooming;
        }
        if (ZoomifySettings.Companion.getKeybindScrolling()) {
            int n;
            while (scrollZoomIn.method_1436()) {
                n = scrollSteps;
                scrollSteps = n + 1;
            }
            while (scrollZoomOut.method_1436()) {
                n = scrollSteps;
                scrollSteps = n + -1;
            }
            scrollSteps = RangesKt.coerceIn((int)scrollSteps, (ClosedRange)((ClosedRange)new IntRange(0, 30)));
        }
        this.handleSpyglass(minecraft, prevZooming);
        ZoomHelper.tick$default(zoomHelper, zooming, scrollSteps, 0.0, 4, null);
        ZoomHelper.tick$default(secondaryZoomHelper, secondaryZooming, scrollSteps, 0.0, 4, null);
        if (displayGui) {
            displayGui = false;
            minecraft.method_1507(SettingsGuiFactoryKt.createSettingsGui(minecraft.field_1755));
        }
    }

    @JvmStatic
    public static final float getZoomDivisor(float tickDelta) {
        double d;
        if (!zooming) {
            if (!((Boolean)KotlinExtsKt.getValue(ZoomifySettings.Companion.getRetainZoomSteps())).booleanValue()) {
                scrollSteps = 0;
            }
            zoomHelper.reset();
        }
        double it = d = zoomHelper.getZoomDivisor(tickDelta);
        boolean bl = false;
        previousZoomDivisor = it;
        return (float)(d * secondaryZoomHelper.getZoomDivisor(tickDelta));
    }

    @JvmStatic
    public static final void mouseZoom(double mouseDelta) {
        if (mouseDelta > 0.0) {
            int n = scrollSteps;
            scrollSteps = n + 1;
        } else if (mouseDelta < 0.0) {
            int n = scrollSteps;
            scrollSteps = n + -1;
        }
        scrollSteps = RangesKt.coerceIn((int)scrollSteps, (ClosedRange)((ClosedRange)new IntRange(0, 30)));
    }

    private final void handleSpyglass(class_310 minecraft, boolean prevZooming) {
        class_1297 cameraEntity = minecraft.field_1719;
        if (cameraEntity instanceof class_742) {
            boolean requiresSpyglass;
            switch (WhenMappings.$EnumSwitchMapping$1[((SpyglassBehaviour)KotlinExtsKt.getValue(ZoomifySettings.Companion.getSpyglassBehaviour())).ordinal()]) {
                case 1: {
                    if (((class_742)cameraEntity).method_24518(class_1802.field_27070)) break;
                    zooming = false;
                    break;
                }
                case 2: {
                    if (((class_742)cameraEntity).method_31548().method_43256(Zoomify::handleSpyglass$lambda$3)) break;
                    zooming = false;
                    break;
                }
                case 3: {
                    if (!((class_742)cameraEntity).method_31550()) break;
                    zooming = zooming && minecraft.field_1690.method_31044().method_31034();
                }
            }
            boolean bl = requiresSpyglass = KotlinExtsKt.getValue(ZoomifySettings.Companion.getSpyglassBehaviour()) != SpyglassBehaviour.COMBINE;
            if (requiresSpyglass && ((class_742)cameraEntity).method_31550()) {
                zooming = true;
            }
            if (shouldPlaySound && !zooming && prevZooming) {
                ((class_742)cameraEntity).method_5783(class_3417.field_26973, 1.0f, 1.0f);
            }
            shouldPlaySound = switch (WhenMappings.$EnumSwitchMapping$2[((SoundBehaviour)KotlinExtsKt.getValue(ZoomifySettings.Companion.getSpyglassSoundBehaviour())).ordinal()]) {
                case 1 -> false;
                case 2 -> true;
                case 3 -> {
                    if (((class_742)cameraEntity).method_31550() || requiresSpyglass && zooming && ((class_742)cameraEntity).method_24518(class_1802.field_27070)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (Zoomify.shouldRenderOverlay((class_742)cameraEntity, minecraft.field_1690.method_31044().method_31034() && ((class_742)cameraEntity).method_31550()) && requiresSpyglass) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (shouldPlaySound && zooming && !prevZooming) {
                ((class_742)cameraEntity).method_5783(class_3417.field_26972, 1.0f, 1.0f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean shouldRenderOverlay(@NotNull class_742 player, boolean isUsingSpyglass) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        switch (WhenMappings.$EnumSwitchMapping$3[((OverlayVisibility)KotlinExtsKt.getValue(ZoomifySettings.Companion.getSpyglassOverlayVisibility())).ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                boolean bl = zooming;
                return bl;
            }
            case 3: {
                if (isUsingSpyglass) return true;
                if (!zooming) return false;
                if (!player.method_24518(class_1802.field_27070)) return false;
                if (KotlinExtsKt.getValue(ZoomifySettings.Companion.getSpyglassBehaviour()) == SpyglassBehaviour.COMBINE) return false;
                return true;
            }
            case 4: {
                if (!zooming) return false;
                if (!player.method_31548().method_43256(Zoomify::shouldRenderOverlay$lambda$4)) return false;
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void onGameFinishedLoading() {
        if (ZoomifySettings.Companion.getFirstLaunch()) {
            LOGGER.info("Zoomify detected first launch!");
            this.detectConflictingToast();
            Migrator.Companion.checkMigrations();
        }
    }

    public final boolean unbindConflicting() {
        class_310 minecraft = class_310.method_1551();
        if (!zoomKey.method_1415()) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])minecraft.field_1690.field_1839);
            while (iterator.hasNext()) {
                class_304 key = (class_304)iterator.next();
                if (Intrinsics.areEqual((Object)key, (Object)zoomKey) || !key.equals((Object)zoomKey)) continue;
                key.method_1422(class_3675.field_16237);
                minecraft.field_1690.method_1640();
                class_5250 class_52502 = class_2561.method_43471((String)"zoomify.toast.unbindConflicting.name");
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
                class_2561 class_25612 = (class_2561)class_52502;
                Object[] objectArray = new Object[]{class_2561.method_43471((String)key.method_1431())};
                class_5250 class_52503 = class_2561.method_43469((String)"zoomify.toast.unbindConflicting.description", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
                MinecraftExtKt.toast(class_25612, (class_2561)class_52503, false);
                return true;
            }
        }
        return false;
    }

    private final void detectConflictingToast() {
        boolean bl;
        block3: {
            class_310 minecraft = class_310.method_1551();
            if (zoomKey.method_1415()) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)minecraft.field_1690.field_1839, (String)"keyMappings");
            Object[] $this$any$iv = minecraft.field_1690.field_1839;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                class_304 it = (class_304)element$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)zoomKey) && it.equals((Object)zoomKey))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            class_5250 class_52502 = class_2561.method_43471((String)"zoomify.toast.conflictingKeybind.title");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            class_2561 class_25612 = (class_2561)class_52502;
            Object[] objectArray = new Object[]{class_2561.method_43471((String)"yacl3.config.zoomify.category.misc")};
            class_5250 class_52503 = class_2561.method_43469((String)"zoomify.toast.conflictingKeybind.description", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
            MinecraftExtKt.toast(class_25612, (class_2561)class_52503, true);
        }
    }

    private static final int onInitializeClient$lambda$1$lambda$0(CommandContext it) {
        displayGui = true;
        return 0;
    }

    private static final void onInitializeClient$lambda$1(CommandDispatcher dispatcher, class_7157 class_71572) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"zoomify").executes(Zoomify::onInitializeClient$lambda$1$lambda$0));
    }

    private static final boolean handleSpyglass$lambda$3(class_1799 it) {
        return it.method_31574(class_1802.field_27070);
    }

    private static final boolean shouldRenderOverlay$lambda$4(class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.method_31574(class_1802.field_27070);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"Zoomify");
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
        zoomKey = new class_304("zoomify.key.zoom", class_3675.class_307.field_1668, 67, "zoomify.key.category");
        secondaryZoomKey = new class_304("zoomify.key.zoom.secondary", class_3675.class_307.field_1668, 295, "zoomify.key.category");
        scrollZoomIn = new class_304("zoomify.key.zoom.in", -1, "zoomify.key.category");
        scrollZoomOut = new class_304("zoomify.key.zoom.out", -1, "zoomify.key.category");
        zoomHelper = DefaultZoomHelpersKt.RegularZoomHelper(ZoomifySettings.Companion);
        secondaryZoomHelper = DefaultZoomHelpersKt.SecondaryZoomHelper(ZoomifySettings.Companion);
        previousZoomDivisor = 1.0;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ZoomKeyBehaviour.values().length];
            try {
                nArray[ZoomKeyBehaviour.HOLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomKeyBehaviour.TOGGLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpyglassBehaviour.values().length];
            try {
                nArray[SpyglassBehaviour.ONLY_ZOOM_WHILE_HOLDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyglassBehaviour.ONLY_ZOOM_WHILE_CARRYING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyglassBehaviour.OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SoundBehaviour.values().length];
            try {
                nArray[SoundBehaviour.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.ONLY_SPYGLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.WITH_OVERLAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[OverlayVisibility.values().length];
            try {
                nArray[OverlayVisibility.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.HOLDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.CARRYING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

