/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class FilteringScreen
extends class_437 {
    protected List<EntryStack<?>> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)FilteringScreen.this.entryStacks.size() / ((float)FilteringScreen.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        public Rectangle getBounds() {
            return FilteringScreen.this.getBounds();
        }

        public int getScrollBarX(int maxX) {
            return FilteringScreen.this.field_22789 - 7;
        }
    };
    class_437 parent;
    private Set<EntryStack<?>> configFiltered;
    private Tooltip tooltip = null;
    private List<EntryStack<?>> entryStacks = null;
    private Rectangle innerBounds;
    private List<FilteringListEntry> entries = Collections.emptyList();
    private List<class_364> elements = Collections.emptyList();
    private List<PointPair> points = new ArrayList<PointPair>();
    private OverlaySearchField searchField;
    private class_4185 selectAllButton;
    private class_4185 selectNoneButton;
    private class_4185 hideButton;
    private class_4185 showButton;
    private class_4185 backButton;
    private Predicate<Rectangle> selectionCache;
    private SearchFilter lastFilter = SearchFilter.matchAll();

    public FilteringScreen(Set<EntryStack<?>> configFiltered) {
        super((class_2561)class_2561.method_43471((String)"config.roughlyenoughitems.filteringScreen"));
        this.configFiltered = configFiltered;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        class_5250 selectAllText = class_2561.method_43471((String)"config.roughlyenoughitems.filteredEntries.selectAll");
        this.selectAllButton = class_4185.method_46430((class_2561)selectAllText, button -> {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)selectAllText) + 10, 20).method_46431();
        class_5250 selectNoneText = class_2561.method_43471((String)"config.roughlyenoughitems.filteredEntries.selectNone");
        this.selectNoneButton = class_4185.method_46430((class_2561)selectNoneText, button -> this.points.clear()).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)selectNoneText) + 10, 20).method_46431();
        class_5250 hideText = class_2561.method_43471((String)"config.roughlyenoughitems.filteredEntries.hide");
        this.hideButton = class_4185.method_46430((class_2561)hideText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || entry.isFiltered()) continue;
                configFiltered.add(stack);
                entry.dirty = true;
            }
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)hideText) + 10, 20).method_46431();
        class_5250 showText = class_2561.method_43471((String)"config.roughlyenoughitems.filteredEntries.show");
        this.showButton = class_4185.method_46430((class_2561)showText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || !configFiltered.remove(stack)) continue;
                entry.dirty = true;
            }
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)showText) + 10, 20).method_46431();
        class_5250 backText = class_2561.method_43470((String)"\u21a9 ").method_10852((class_2561)class_2561.method_43471((String)"gui.back"));
        this.backButton = class_4185.method_46430((class_2561)backText, button -> {
            this.field_22787.method_1507(this.parent);
            this.parent = null;
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)backText) + 10, 20).method_46431();
        this.searchField.isMain = false;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        this.parent = null;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 30, this.field_22789, this.field_22790 - 30);
    }

    public void method_25426() {
        super.method_25426();
        Rectangle bounds = this.getBounds();
        this.updateSearch(this.searchField.getText());
        this.selectAllButton.method_46421(2);
        this.selectAllButton.method_46419(bounds.getMaxY() - 22);
        this.selectNoneButton.method_46421(4 + this.selectAllButton.method_25368());
        this.selectNoneButton.method_46419(bounds.getMaxY() - 22);
        int searchFieldWidth = Math.max(bounds.width - (this.selectNoneButton.method_46426() + this.selectNoneButton.method_25368() + this.hideButton.method_25368() + this.showButton.method_25368() + 12), 100);
        this.searchField.getBounds().setBounds(this.selectNoneButton.method_46426() + this.selectNoneButton.method_25368() + 4, bounds.getMaxY() - 21, searchFieldWidth, 18);
        this.hideButton.method_46421(bounds.getMaxX() - this.hideButton.method_25368() - this.showButton.method_25368() - 4);
        this.hideButton.method_46419(bounds.getMaxY() - 22);
        this.showButton.method_46421(bounds.getMaxX() - this.showButton.method_25368() - 2);
        this.showButton.method_46419(bounds.getMaxY() - 22);
        this.backButton.method_46421(4);
        this.backButton.method_46419(4);
        this.searchField.setResponder(this::updateSearch);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        int nextIndex;
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.updateSelectionCache();
        Rectangle bounds = this.getBounds();
        this.tooltip = null;
        UpdatedListWidget.renderAs(this.field_22787, this.field_22789, this.field_22790, bounds.y, this.field_22790, graphics, delta);
        if (bounds.isEmpty()) {
            return;
        }
        graphics.method_44379(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        for (FilteringListEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
        BatchedEntryRendererManager<FilteringListEntry> manager = new BatchedEntryRendererManager<FilteringListEntry>();
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack<?> stack = this.entryStacks.get(i);
            FilteringListEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry((EntryStack)stack);
            manager.add(entry);
            ++nextIndex;
        }
        manager.render(graphics, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(graphics, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 300.0f);
        this.searchField.method_25394(graphics, mouseX, mouseY, delta);
        this.selectAllButton.method_25394(graphics, mouseX, mouseY, delta);
        this.selectNoneButton.method_25394(graphics, mouseX, mouseY, delta);
        this.hideButton.method_25394(graphics, mouseX, mouseY, delta);
        this.showButton.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_51448().method_22909();
        graphics.method_44380();
        graphics.method_64039(source -> {
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            class_4588 buffer = source.getBuffer(class_1921.method_51784());
            buffer.method_22918(matrix, 0.0f, (float)(bounds.y + 4), 0.0f).method_1336(0, 0, 0, 0);
            buffer.method_22918(matrix, (float)this.field_22789, (float)(bounds.y + 4), 0.0f).method_1336(0, 0, 0, 0);
            buffer.method_22918(matrix, (float)this.field_22789, (float)bounds.y, 0.0f).method_1336(0, 0, 0, 255);
            buffer.method_22918(matrix, 0.0f, (float)bounds.y, 0.0f).method_1336(0, 0, 0, 255);
        });
        this.backButton.method_25394(graphics, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).renderTooltip(graphics, this.tooltip);
        }
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int)((float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f), 12, -1);
        class_5250 hint = class_2561.method_43471((String)"config.roughlyenoughitems.filteringRulesScreen.hint").method_27692(class_124.field_1054);
        graphics.method_27535(this.field_22793, (class_2561)hint, this.field_22789 - this.field_22793.method_27525((class_5348)hint) - 15, 12, -1);
    }

    private Predicate<Rectangle> getSelection() {
        return this.selectionCache;
    }

    private void updateSelectionCache() {
        if (!this.points.isEmpty()) {
            Predicate<Rectangle> predicate = rect -> false;
            for (PointPair pair : this.points) {
                Point firstPoint = pair.firstPoint();
                Point secondPoint = pair.secondPoint();
                if (secondPoint == null) {
                    secondPoint = PointHelper.ofMouse();
                    secondPoint.translate(0, this.scrolling.scrollAmountInt());
                }
                int left = Math.min(firstPoint.x, secondPoint.x);
                int top = Math.min(firstPoint.y, secondPoint.y);
                int right = Math.max(firstPoint.x, secondPoint.x);
                int bottom = Math.max(firstPoint.y, secondPoint.y);
                Rectangle rectangle = new Rectangle(left, top - this.scrolling.scrollAmountInt(), Math.max(1, right - left), Math.max(1, bottom - top));
                predicate = predicate.or(arg_0 -> ((Rectangle)rectangle).intersects(arg_0));
            }
            this.selectionCache = predicate;
            return;
        }
        this.selectionCache = rect -> false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastFilter = SearchProvider.getInstance().createFilter(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(this::matches).map(EntryStack::normalize).forEachOrdered(list::add);
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        EntrySerializer<?> serializer = stack.getDefinition().getSerializer();
        if (serializer == null) {
            return false;
        }
        return this.lastFilter.test(stack);
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = FilteringScreen.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add(new FilteringListEntry(xPos, yPos, entrySize));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((class_364)this.searchField);
    }

    public List<? extends class_364> method_25396() {
        return this.elements;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        if (this.getBounds().contains(mouseX, mouseY)) {
            if (this.searchField.method_25402(mouseX, mouseY, button)) {
                this.points.clear();
                return true;
            }
            if (this.selectAllButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.selectNoneButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.hideButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.showButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (button == 0) {
                if (!class_437.method_25442()) {
                    this.points.clear();
                }
                this.points.add(new PointPair(new Point(mouseX, mouseY + this.scrolling.scrollAmount()), null));
                return true;
            }
        }
        return this.backButton.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        PointPair pair;
        if (button == 0 && !this.points.isEmpty() && (pair = this.points.get(this.points.size() - 1)).secondPoint() == null) {
            this.points.set(this.points.size() - 1, new PointPair(pair.firstPoint(), new Point(mouseX, mouseY + this.scrolling.scrollAmount())));
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int keyCode) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25400(chr, keyCode)) continue;
            return true;
        }
        return super.method_25400(chr, keyCode);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            this.backButton.method_25306();
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean method_25401(double double_1, double double_2, double amountX, double amountY) {
        if (this.getBounds().contains(double_1, double_2) && amountY != 0.0) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        super.method_25401(double_1, double_2, amountX, amountY);
        return true;
    }

    private class FilteringListEntry
    extends EntryWidget {
        private int backupY;
        private boolean filtered;
        private boolean dirty;

        private FilteringListEntry(int x, int y, int entrySize) {
            super(new Point(x, y));
            this.filtered = false;
            this.dirty = true;
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = entrySize;
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringScreen.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawExtra(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (this.isSelected()) {
                boolean filtered = this.isFiltered();
                Rectangle bounds = this.getBounds();
                graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), filtered ? -1862270977 : 0x55FFFFFF, filtered ? -1862270977 : 0x55FFFFFF);
            }
        }

        public boolean isSelected() {
            return FilteringScreen.this.getSelection().test(this.getBounds());
        }

        public boolean isFiltered() {
            if (this.dirty) {
                this.filtered = FilteringScreen.this.configFiltered.contains(this.getCurrentEntry());
                this.dirty = false;
            }
            return this.filtered;
        }

        @Override
        protected void drawBackground(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -65536, -65536);
            }
        }

        @Override
        protected void queueTooltip(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (FilteringScreen.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            Tooltip tooltip = this.getCurrentTooltip(TooltipContext.of(new Point(mouseX, mouseY), class_1792.class_9635.method_59528((class_1937)this.minecraft.field_1687)));
            if (tooltip != null) {
                FilteringScreen.this.tooltip = tooltip;
            }
        }
    }

    private record PointPair(Point firstPoint, @Nullable Point secondPoint) {
    }
}

