/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import journeymap.common.Journeymap;
import journeymap.common.mixin.common.SerializableChunkDataInvoker;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2808;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_2902;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC;
    private static final Logger logger;

    public static ProcessedChunk read(class_638 level, class_1923 chunkPos, class_2487 chunkTag) {
        if (class_2808.field_12807 == class_2852.method_67685((class_2487)chunkTag).method_12164()) {
            byte[][][][] lights = new byte[24][16][16][16];
            boolean lightOn = (Boolean)chunkTag.method_10577("isLightOn").get();
            class_2499 sections = (class_2499)chunkTag.method_10554("sections").get();
            int sectionsCount = level.method_32890();
            class_2826[] chunkSections = new class_2826[sectionsCount];
            class_2378 registry = level.method_30349().method_30530(class_7924.field_41236);
            Codec<class_7522<class_6880<class_1959>>> codec = SerializableChunkDataInvoker.invokeMakeBiomeCodec((class_2378<class_1959>)registry);
            for (int j = 0; j < sections.size(); ++j) {
                class_2487 section = (class_2487)sections.method_10602(j).get();
                byte sectionTopY = (Byte)section.method_10571("Y").get();
                int sectionIndex = level.method_31603((int)sectionTopY);
                if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                    class_2826 chunkSection;
                    class_2841 blockStateContainer = section.method_10545("block_states") ? (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)section.method_10562("block_states").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(class_2852.class_9314::new) : new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                    Object biomeContainer = section.method_10545("biomes") ? (class_7522)codec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)section.method_10562("biomes").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(class_2852.class_9314::new) : new class_2841(registry.method_40295(), (Object)registry.method_46747(class_1972.field_9451), class_2841.class_6563.field_34570);
                    chunkSections[sectionIndex] = chunkSection = new class_2826(blockStateContainer, (class_7522)biomeContainer);
                }
                if (!lightOn || !section.method_10545("BlockLight")) continue;
                class_4076 lightPos = class_4076.method_18681((class_1923)chunkPos, (int)sectionTopY);
                byte[] lightsArray = (byte[])section.method_10547("BlockLight").get();
                for (int z = 0; z <= 15; ++z) {
                    for (int x = 0; x <= 15; ++x) {
                        for (int y = lightPos.method_19528(); y <= lightPos.method_19531(); ++y) {
                            if (lightsArray.length != 2048) continue;
                            int localY = class_4076.method_18684((int)y);
                            lights[j][x][localY][z] = CustomChunkReader.getSectionLightValue(lightsArray, x, localY, z);
                        }
                    }
                }
            }
            class_2818 chunkAccess = new class_2818((class_1937)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
            chunkAccess.method_12020(lightOn);
            class_2487 heightmaps = (class_2487)chunkTag.method_10562("Heightmaps").get();
            EnumSet<class_2902.class_2903> heightmapEnums = EnumSet.noneOf(class_2902.class_2903.class);
            for (class_2902.class_2903 heightmapTypes : chunkAccess.method_12009().method_12160()) {
                String key = heightmapTypes.method_12605();
                if (heightmaps.method_10545(key)) {
                    chunkAccess.method_12037(heightmapTypes, (long[])heightmaps.method_10565(key).get());
                    continue;
                }
                heightmapEnums.add(heightmapTypes);
            }
            class_2902.method_16684((class_2791)chunkAccess, heightmapEnums);
            return new ProcessedChunk(chunkAccess, lights);
        }
        return null;
    }

    private static byte getSectionLightValue(byte[] array, int x, int y, int z) {
        try {
            if (array != null) {
                int index = y << 8 | (z << 4) + x;
                int byteIndex = index >> 1;
                int nibbleIndex = index & 1;
                return (byte)(array[byteIndex] >> 4 * nibbleIndex & 0xF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static void logErrors(class_1923 chunkPos, int chunkSectionY, String errorMessage) {
        logger.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.field_9181, chunkSectionY, chunkPos.field_9180, errorMessage});
    }

    static {
        logger = Journeymap.getLogger();
        BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    }

    public record ProcessedChunk(class_2818 chunk, byte[][][][] light) {
    }
}

