/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.log.StatTimer;
import journeymap.client.model.MapType;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.RegionTexture;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ImageHolder {
    static final Logger logger = Journeymap.getLogger();
    final MapType mapType;
    final Path imagePath;
    final int imageSize;
    boolean blank = true;
    boolean dirty = true;
    boolean partialUpdate;
    private volatile ReentrantLock writeLock = new ReentrantLock();
    private volatile RegionTexture texture;
    private boolean debug;
    private HashSet<class_1923> updatedChunks = new HashSet();

    ImageHolder(MapType mapType, File imageFile, int imageSize) {
        this.mapType = mapType;
        this.imagePath = imageFile.toPath();
        this.imageSize = imageSize;
        this.debug = logger.isEnabled(Level.DEBUG);
        this.getTexture();
    }

    File getFile() {
        return this.imagePath.toFile();
    }

    MapType getMapType() {
        return this.mapType;
    }

    class_1011 getImage() {
        return this.texture.getNativeImage();
    }

    void setImage(class_1011 image) {
        this.texture.setNativeImage(image, true);
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void partialImageUpdate(class_1011 imagePart, int startX, int startY) {
        this.writeLock.lock();
        StatTimer timer = StatTimer.get("ImageHolder.partialImageUpdate", 5, 500);
        timer.start();
        try {
            if (this.texture != null) {
                this.blank = false;
                int width = imagePart.method_4307();
                int height = imagePart.method_4323();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        this.texture.getNativeImage().method_61941(x + startX, y + startY, imagePart.method_61940(x, y));
                    }
                }
                this.partialUpdate = true;
                this.updatedChunks.add(new class_1923(startX, startY));
                this.setDirty();
            } else {
                logger.warn(String.valueOf(this) + " can't partialImageUpdate without a texture.");
            }
        }
        finally {
            timer.stop();
            this.writeLock.unlock();
        }
    }

    void finishPartialImageUpdates() {
        this.writeLock.lock();
        try {
            if (this.partialUpdate && !this.updatedChunks.isEmpty()) {
                class_1011 textureImage = this.texture.getNativeImage();
                this.texture.setNativeImage(textureImage, true, this.updatedChunks);
                this.setDirty();
                this.partialUpdate = false;
                this.updatedChunks.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasTexture() {
        return this.texture != null && !this.texture.isDefunct();
    }

    public RegionTexture getTexture() {
        if (!this.hasTexture()) {
            class_1011 image;
            File temp;
            if (!this.imagePath.toFile().exists() && (temp = new File(String.valueOf(this.imagePath) + ".new")).exists()) {
                Journeymap.getLogger().warn("Recovered image file: {}", (Object)temp);
                temp.renameTo(this.imagePath.toFile());
            }
            try {
                image = RegionImageHandler.readRegionImage(this.imagePath.toFile());
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Error reading image {}, {}", (Object)this.imagePath, (Object)t);
                image = null;
            }
            if (image == null || image.field_4988 == 0L || image.method_4307() != this.imageSize || image.method_4323() != this.imageSize) {
                image = ImageUtil.getNewBlankImage(this.imageSize, this.imageSize);
                this.blank = true;
            } else {
                this.blank = false;
            }
            this.dirty = false;
            this.texture = new RegionTexture(image, this.imagePath.toString());
        }
        return this.texture;
    }

    private void setDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    protected boolean writeToDisk(boolean async) {
        if (this.blank || this.texture == null || !this.texture.hasImage()) {
            return false;
        }
        if (async) {
            try {
                class_156.method_27958().execute(this::writeNextIO);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Failed to write image async: " + String.valueOf(this));
            }
            return true;
        }
        boolean success = false;
        for (int tries = 0; tries < 5; ++tries) {
            if (this.writeNextIO()) {
                continue;
            }
            success = true;
            break;
        }
        if (!success) {
            Journeymap.getLogger().warn("Couldn't write file after 5 tries: " + String.valueOf(this));
        }
        return success;
    }

    public boolean writeNextIO() {
        if (this.texture == null || !this.texture.hasImage()) {
            return false;
        }
        try {
            if (this.writeLock.tryLock(250L, TimeUnit.MILLISECONDS)) {
                this.writeImageToFile();
                this.writeLock.unlock();
                return false;
            }
            logger.warn("Couldn't get write lock for file: " + String.valueOf(this.writeLock) + " for " + String.valueOf(this));
            return true;
        }
        catch (InterruptedException e) {
            logger.warn("Timeout waiting for write lock  " + String.valueOf(this.writeLock) + " for " + String.valueOf(this));
            return true;
        }
    }

    private void writeImageToFile() {
        File imageFile = this.imagePath.toFile();
        try {
            class_1011 image = this.texture.getNativeImage();
            if (image != null && image.field_4988 > 0L) {
                if (!imageFile.exists()) {
                    imageFile.getParentFile().mkdirs();
                }
                File temp = new File(imageFile.getParentFile(), imageFile.getName() + ".new");
                image.method_4325(temp);
                if (imageFile.exists() && !imageFile.delete()) {
                    logger.warn("Couldn't delete old file " + imageFile.getName());
                }
                if (temp.renameTo(imageFile)) {
                    this.dirty = false;
                } else {
                    logger.warn("Couldn't rename temp file to " + imageFile.getName());
                }
                if (this.debug) {
                    logger.debug("Wrote to disk: " + String.valueOf(imageFile));
                }
            }
        }
        catch (IOException e) {
            if (imageFile.exists()) {
                try {
                    logger.error("IOException updating file, will delete and retry: " + String.valueOf(this) + ": " + LogFormatter.toPartialString(e));
                    imageFile.delete();
                    this.writeImageToFile();
                }
                catch (Throwable e2) {
                    logger.error("Exception after delete/retry: " + String.valueOf(this) + ": " + LogFormatter.toPartialString(e));
                }
            } else {
                logger.error("IOException creating file: " + String.valueOf(this) + ": " + LogFormatter.toPartialString(e));
            }
        }
        catch (Throwable e) {
            logger.error("Exception writing to disk: " + String.valueOf(this) + ": " + LogFormatter.toPartialString(e));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mapType", (Object)this.mapType).add("texture null", this.texture == null).add("texture bound", this.texture != null && this.texture.isBound()).add("textureId", this.texture != null ? this.texture.id() : -1).add("dirty", this.dirty).add("imagePath", (Object)this.imagePath).toString();
    }

    public void clear() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderWrapper.recordRenderQueue(() -> {
                this.writeLock.lock();
                this.texture.close();
                this.texture = null;
                this.writeLock.unlock();
            });
        } else {
            this.writeLock.lock();
            this.texture.close();
            this.texture = null;
            this.writeLock.unlock();
        }
    }

    public long getImageTimestamp() {
        if (this.texture != null) {
            return this.texture.getLastImageUpdate();
        }
        return 0L;
    }
}

