/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import journeymap.api.services.Services;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.GeckoLibHelper;
import journeymap.client.render.draw.LivingEntityRendererETFTextureGetter;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.accessors.NativeImageAccess;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.AgeableMobRendererAccessor;
import journeymap.common.mixin.client.EnderDragonModelMixin;
import journeymap.common.mixin.client.EnderDragonRendererMixin;
import journeymap.common.mixin.client.ModelPartMixin;
import journeymap.common.mixin.client.PufferfishRendererMixin;
import journeymap.common.mixin.client.RabbitModelMixin;
import journeymap.common.mixin.client.SalmonRendererInvoker;
import journeymap.common.mixin.client.TropicalFishRendererMixin;
import journeymap.common.util.ReflectionHelper;
import net.minecraft.class_10042;
import net.minecraft.class_10076;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1474;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_3879;
import net.minecraft.class_3882;
import net.minecraft.class_3884;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_565;
import net.minecraft.class_576;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_584;
import net.minecraft.class_596;
import net.minecraft.class_599;
import net.minecraft.class_604;
import net.minecraft.class_609;
import net.minecraft.class_625;
import net.minecraft.class_630;
import net.minecraft.class_7751;
import net.minecraft.class_7923;
import net.minecraft.class_889;
import net.minecraft.class_895;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import net.minecraft.class_936;
import net.minecraft.class_938;
import net.minecraft.class_959;
import net.minecraft.class_9945;
import net.minecraft.class_9947;
import net.minecraft.class_9990;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class MobIconCache {
    private static final String MOB_ICON_FILE_SUFFIX = ".png";
    private static final String OUTLINED_SUFFIX = "_outlined";
    private static HashMap<class_2960, IconTexture> mobsIcons = null;
    private static final Map<class_2960, class_1043> webMapIconCache = Collections.synchronizedMap(new HashMap());
    private static class_1011 markerMask = null;

    public static class_1043 getWebMapIcon(class_2960 loc) {
        return webMapIconCache.get(loc);
    }

    public static Tuple2<class_2960, class_1043> getMobIcon(EntityDTO dto, boolean outlined) {
        MobIconCache.ensureMobIconsLoaded();
        class_2960 mobLocation = dto.entityTypeLocation;
        MobIconCache.addIconIfMissing(dto, mobLocation);
        IconTexture icon = mobsIcons.get(mobLocation);
        if ((JourneymapClient.getInstance().getCoreProperties().legacyIcons.get().booleanValue() || dto.hasCustomIcon || icon == null) && dto.entityIconLocation != null) {
            try {
                class_1043 tex = TextureCache.getTexture(dto.entityIconLocation);
                if (tex != null && ((TextureAccess)tex).journeymap$hasImage()) {
                    mobsIcons.put(dto.entityIconLocation, new IconTexture(tex, null));
                    webMapIconCache.put(dto.entityIconLocation, tex);
                    return new Tuple2((Object)dto.entityIconLocation, (Object)tex);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error getting texture location for texture {}", (Object)dto.entityTextureLocation, (Object)e);
            }
        }
        if (icon == null) {
            return null;
        }
        if (outlined) {
            webMapIconCache.put(mobLocation, icon.outlined);
            return new Tuple2((Object)mobLocation, (Object)icon.outlined);
        }
        webMapIconCache.put(mobLocation, icon.solid);
        return new Tuple2((Object)mobLocation, (Object)icon.solid);
    }

    private static void ensureMobIconsLoaded() {
        if (mobsIcons == null) {
            mobsIcons = new HashMap();
            markerMask = TextureCache.getTexture(TextureCache.MobIconMask).method_4525();
            class_3300 resourceManager = class_310.method_1551().method_1478();
            Set resourceStacks = resourceManager.method_41265("icon/entity", loc -> loc.method_12832().endsWith(MOB_ICON_FILE_SUFFIX) && loc.method_12836().equals("journeymap")).entrySet();
            for (Map.Entry resources : resourceStacks) {
                HashMap<class_2960, IconTexture> icons = new HashMap<class_2960, IconTexture>();
                for (class_3298 resource : (List)resources.getValue()) {
                    try {
                        boolean outlined;
                        String mobName;
                        class_2960 mobLoc;
                        class_1011 icon = FileHandler.getImageFromStream(resource.method_14482());
                        String[] path = ((class_2960)resources.getKey()).method_12832().split("/");
                        if (path.length != 4 || mobsIcons.containsKey(mobLoc = class_2960.method_60655((String)path[2], (String)(mobName = (outlined = (mobName = path[3]).endsWith("_outlined.png")) ? mobName.replaceAll("_outlined.png", "") : mobName.replaceAll(MOB_ICON_FILE_SUFFIX, ""))))) continue;
                        MobIconCache.addIcon(icons, mobLoc, icon, outlined);
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Could not load Mob icon: {}", (Object)LogFormatter.toString(t));
                    }
                }
                MobIconCache.addMissingSolidOrOutlined(icons);
                mobsIcons.putAll(icons);
            }
            File[] domainsDirs = FileHandler.getMobIconsDomainsDirectories();
            HashMap<class_2960, IconTexture> icons = new HashMap<class_2960, IconTexture>();
            for (File domainDir : domainsDirs) {
                File[] mobsFiles;
                if (!class_2960.method_20209((String)domainDir.getName()) || (mobsFiles = domainDir.listFiles((dir, name) -> name.endsWith(MOB_ICON_FILE_SUFFIX))) == null) continue;
                for (File mobFile : mobsFiles) {
                    try {
                        String mobName = mobFile.getName();
                        boolean outlined = mobName.endsWith("_outlined.png");
                        mobName = outlined ? mobName.replaceAll("_outlined.png", "") : mobName.replaceAll(MOB_ICON_FILE_SUFFIX, "");
                        class_1011 icon = FileHandler.getImageFromFile(mobFile);
                        class_2960 mobLoc = class_2960.method_60655((String)domainDir.getName(), (String)mobName);
                        if (mobsIcons.containsKey(mobLoc)) continue;
                        MobIconCache.addIcon(icons, mobLoc, icon, outlined);
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Could not load Mob icon: {}", (Object)LogFormatter.toString(t));
                    }
                }
            }
            MobIconCache.addMissingSolidOrOutlined(icons);
            mobsIcons.putAll(icons);
        }
    }

    public static void clearCache() {
        webMapIconCache.clear();
        if (mobsIcons != null && !mobsIcons.isEmpty()) {
            mobsIcons.forEach((resource, tex) -> {
                if (tex != null) {
                    class_310.method_1551().method_1531().method_4615(resource);
                    tex.remove();
                }
            });
        }
        mobsIcons = null;
    }

    private static void addIcon(Map<class_2960, IconTexture> icons, class_2960 mob, class_1011 icon, boolean outlined) {
        IconTexture iconTexture = icons.computeIfAbsent(mob, m -> new IconTexture());
        class_1043 texture = new class_1043(null, icon);
        if (outlined) {
            iconTexture.outlined = texture;
        } else {
            iconTexture.solid = texture;
        }
    }

    private static void addMissingSolidOrOutlined(Map<class_2960, IconTexture> icons) {
        for (IconTexture icon : icons.values()) {
            if (icon.solid == null) {
                icon.solid = icon.outlined;
                continue;
            }
            if (icon.outlined != null) continue;
            icon.outlined = icon.solid;
        }
    }

    private static void addIconIfMissing(EntityDTO dto, class_2960 mobLocation) {
        if (!mobsIcons.containsKey(mobLocation)) {
            class_1011 entityIcon = null;
            boolean saveToDisk = true;
            class_1297 entity = (class_1297)dto.getEntityRef().get();
            if (entity != null) {
                class_898 renderManager = class_310.method_1551().method_1561();
                class_897 renderer = renderManager.method_3953(entity);
                class_2960 textureLocation = MobIconCache.getTextureLocation(renderManager.method_3953(entity), entity, dto);
                class_1043 tex = TextureCache.getTexture(textureLocation);
                if (tex == null || !((TextureAccess)tex).journeymap$hasImage()) {
                    mobsIcons.put(mobLocation, null);
                    return;
                }
                class_1011 entityImage = tex.method_4525();
                if (ReflectionHelper.isInstanceOf(renderer, "software.bernie.geckolib.renderer.GeoEntityRenderer")) {
                    boolean isFish = entity instanceof class_1422;
                    List<class_630> head = GeckoLibHelper.getModelParts(entity, mobLocation, !isFish);
                    entityIcon = MobIconCache.getIconFromHead(head, entityImage, mobLocation, isFish);
                    if (entityIcon == null) {
                        entityIcon = MobIconCache.getIconFromHead(head, entityImage, mobLocation, !isFish);
                    }
                } else if (renderer instanceof class_922) {
                    class_596 model;
                    class_599 rendererModel;
                    class_922 mobRenderer = (class_922)renderer;
                    if (renderer instanceof class_9990) {
                        class_9990 ageableMobRenderer = (class_9990)renderer;
                        r = (AgeableMobRendererAccessor)ageableMobRenderer;
                        rendererModel = r.getAdultModel();
                    } else if (renderer instanceof class_936) {
                        class_936 pufferfishRenderer = (class_936)renderer;
                        r = (PufferfishRendererMixin)pufferfishRenderer;
                        rendererModel = r.getBigModel();
                    } else if (renderer instanceof class_938) {
                        class_938 salmonRenderer = (class_938)renderer;
                        r = (SalmonRendererInvoker)salmonRenderer;
                        rendererModel = r.getMediumSalmonModel();
                    } else {
                        rendererModel = mobRenderer.method_4038();
                    }
                    Object parts = ImmutableList.of();
                    if (rendererModel instanceof class_609 || rendererModel instanceof class_576 || rendererModel instanceof class_604 || rendererModel instanceof class_565) {
                        parts = rendererModel.method_63513();
                    } else if (rendererModel instanceof class_596) {
                        model = (class_596)rendererModel;
                        RabbitModelMixin m = (RabbitModelMixin)model;
                        parts = ImmutableList.of((Object)m.getHead());
                    } else if (rendererModel instanceof class_3884 && rendererModel instanceof class_3882) {
                        class_3882 headedModel = (class_3882)rendererModel;
                        if (entity instanceof class_3851) {
                            class_3850 data;
                            class_3852 profession;
                            class_2960 professionKey;
                            class_3851 villager = (class_3851)entity;
                            String type = entity instanceof class_1646 ? "villager" : (entity instanceof class_1641 ? "zombie_villager" : null);
                            if (type != null && (professionKey = class_7923.field_41195.method_10221((Object)(profession = (class_3852)(data = villager.method_7231()).comp_3521().comp_349()))) != class_3852.field_17051.method_29177()) {
                                class_2960 professionRes = professionKey.method_45134($$1x -> "textures/entity/" + type + "/profession/" + $$1x + MOB_ICON_FILE_SUFFIX);
                                class_1011 altEntityImage = MobIconCache.mergeImages(entityImage, professionRes);
                                entityIcon = MobIconCache.getIconFromHead(headedModel.method_2838(), altEntityImage, mobLocation, false);
                                if (altEntityImage != entityImage) {
                                    altEntityImage.close();
                                }
                            }
                        }
                    } else if (renderer instanceof class_959) {
                        class_959 tropicalFishRenderer = (class_959)renderer;
                        if (entity instanceof class_1474) {
                            class_1011 altEntityImage;
                            class_583<class_10076> tropicalFishModel;
                            class_1474 tropicalFish = (class_1474)entity;
                            if (tropicalFish.method_66681().method_47867() == class_1474.class_7991.field_41574) {
                                tropicalFishModel = ((TropicalFishRendererMixin)tropicalFishRenderer).getModelA();
                                altEntityImage = MobIconCache.mergeImages(entityImage, class_2960.method_60654((String)"textures/entity/fish/tropical_a_pattern_1.png"), 0xFF0000, 0xFFFFFF);
                            } else {
                                tropicalFishModel = ((TropicalFishRendererMixin)tropicalFishRenderer).getModelB();
                                altEntityImage = MobIconCache.mergeImages(entityImage, class_2960.method_60654((String)"textures/entity/fish/tropical_b_pattern_4.png"), 8991416, 16701501);
                            }
                            class_630 body = tropicalFishModel.method_62104("root").orElse(null);
                            entityIcon = MobIconCache.getIconFromHead(body, altEntityImage, mobLocation, true);
                            if (altEntityImage != entityImage) {
                                altEntityImage.close();
                            }
                        }
                    } else if (entity instanceof class_1422 || rendererModel instanceof class_889) {
                        parts = ImmutableList.of((Object)rendererModel.method_63512());
                    }
                    if (parts.isEmpty()) {
                        Optional headPart = rendererModel.method_62104("head");
                        if (headPart.isEmpty()) {
                            headPart = rendererModel.method_62104("body");
                        }
                        parts = ImmutableList.of((Object)headPart.orElseGet(() -> ((class_3879)rendererModel).method_63512()));
                    }
                    if (entityIcon == null && !parts.isEmpty()) {
                        boolean rotated = rendererModel instanceof class_9947 || rendererModel instanceof class_578 || rendererModel instanceof class_7751 || rendererModel instanceof class_9945 || rendererModel instanceof class_584 || rendererModel instanceof class_889 || entity instanceof class_1422;
                        entityIcon = MobIconCache.getIconFromHead((Iterable<class_630>)parts, entityImage, mobLocation, rotated);
                        if (entityIcon == null) {
                            entityIcon = MobIconCache.getIconFromHead((Iterable<class_630>)parts, entityImage, mobLocation, !rotated);
                        }
                    } else {
                        class_583 rotated = mobRenderer.method_4038();
                        if (rotated instanceof class_583) {
                            model = rotated;
                            if (ReflectionHelper.isInstanceOf(mobRenderer.method_4038(), "com.cobblemon.mod.common.client.render.models.blockbench.npc.PosableNPCModel")) {
                                saveToDisk = false;
                                class_1043 texture = TextureCache.getTexture(textureLocation);
                                entityIcon = IgnSkin.cropToFace(texture.method_4525()).method_4525();
                                entityIcon = MobIconCache.cropImage(entityIcon);
                                entityIcon = MobIconCache.resizeImage(entityIcon, 4, false);
                                MobIconCache.maskImage(entityIcon);
                            }
                        }
                    }
                } else if (renderer instanceof class_895) {
                    class_895 dragonRenderer = (class_895)renderer;
                    class_625 model = ((EnderDragonRendererMixin)dragonRenderer).getModel();
                    entityIcon = MobIconCache.getIconFromHead(((EnderDragonModelMixin)model).getHead(), entityImage, mobLocation, false);
                }
            }
            if (entityIcon != null && mobLocation != null) {
                class_1011 outlined = MobIconCache.generateOutlined(entityIcon);
                class_2960 outlinedLocation = mobLocation.method_45136(mobLocation.method_12832() + OUTLINED_SUFFIX);
                mobsIcons.put(mobLocation, new IconTexture(new class_1043(null, entityIcon), new class_1043(null, outlined)));
                if (saveToDisk) {
                    String error;
                    File domainDir = FileHandler.getMobIconsDomainsDirectory(mobLocation);
                    File iconFile = new File(domainDir, mobLocation.method_12832() + MOB_ICON_FILE_SUFFIX);
                    File outlinedFile = new File(domainDir, outlinedLocation.method_12832() + MOB_ICON_FILE_SUFFIX);
                    try {
                        if (!iconFile.exists()) {
                            entityIcon.method_4325(iconFile);
                        }
                    }
                    catch (IOException e) {
                        error = "Could not save icon to file: " + String.valueOf(iconFile) + ": " + e.getMessage();
                        Journeymap.getLogger().error(error);
                    }
                    try {
                        if (!outlinedFile.exists()) {
                            outlined.method_4325(outlinedFile);
                        }
                    }
                    catch (IOException e) {
                        error = "Could not save outlined icon to file: " + String.valueOf(outlinedFile) + ": " + e.getMessage();
                        Journeymap.getLogger().error(error);
                    }
                }
            } else {
                mobsIcons.put(mobLocation, null);
            }
        }
    }

    private static class_1011 mergeImages(class_1011 bottomImage, class_2960 top) {
        return MobIconCache.mergeImages(bottomImage, top, 0xFFFFFF, 0xFFFFFF);
    }

    private static class_1011 mergeImages(class_1011 bottomImage, class_2960 top, int bottomTint, int topTint) {
        class_1011 newImage = null;
        try {
            class_1043 topTex = TextureCache.getTexture(top);
            if (topTex == null || !((TextureAccess)topTex).journeymap$hasImage()) {
                return bottomImage;
            }
            class_1011 topImage = topTex.method_4525();
            if (bottomImage.method_4307() != ((TextureAccess)topTex).journeymap$getWidth() || bottomImage.method_4323() != ((TextureAccess)topTex).journeymap$getHeight()) {
                return bottomImage;
            }
            newImage = ImageUtil.getNewBlankImage(bottomImage.method_4307(), bottomImage.method_4323());
            for (int y = 0; y < bottomImage.method_4323(); ++y) {
                for (int x = 0; x < bottomImage.method_4307(); ++x) {
                    int color = topImage.method_61940(x, y);
                    color = (color & 0xFF000000) == 0 ? RGB.tintRgba(bottomImage.method_61940(x, y), bottomTint) : RGB.tintRgba(color, topTint);
                    newImage.method_61941(x, y, color);
                }
            }
            return newImage;
        }
        catch (Exception e) {
            if (newImage != null) {
                newImage.close();
            }
            return bottomImage;
        }
    }

    private static <T extends class_1297> class_2960 getTextureLocation(class_897<? super T, ?> renderer, T entity, EntityDTO dto) {
        if (Services.COMMON_SERVICE.isModLoaded("entity_texture_features") && renderer instanceof class_922) {
            class_922 mobRenderer = (class_922)renderer;
            if (entity instanceof class_1309) {
                class_922 livingEntityRenderer = mobRenderer;
                class_10042 renderState = (class_10042)livingEntityRenderer.method_55269();
                livingEntityRenderer.method_62355((class_1309)entity, renderState, 1.0f);
                return ((LivingEntityRendererETFTextureGetter)mobRenderer).getETFTextureLocation(renderState);
            }
        }
        return dto.entityTextureLocation;
    }

    private static class_1011 getIconFromHead(class_630 head, class_1011 entityImage, class_2960 mobLocation, boolean rotated) {
        if (head == null) {
            return null;
        }
        return MobIconCache.getIconFromHead((Iterable<class_630>)ImmutableList.of((Object)head), entityImage, mobLocation, rotated);
    }

    private static class_1011 getIconFromHead(Iterable<class_630> heads, class_1011 entityImage, class_2960 mobLocation, boolean rotated) {
        if (heads == null) {
            return null;
        }
        ArrayList<class_630> CEMFixedHeads = new ArrayList<class_630>();
        heads.forEach(head -> ((ModelPartMixin)head).getChildren().forEach((key, part) -> {
            if (key.equals("my_precious")) {
                CEMFixedHeads.add((class_630)part);
            }
        }));
        if (!CEMFixedHeads.isEmpty()) {
            heads = CEMFixedHeads;
        }
        HashMap headPoses = new HashMap();
        heads.forEach(head -> headPoses.put(head, head.method_32084()));
        heads.forEach(class_630::method_41923);
        int scale = 4;
        ArrayList facePolygons = new ArrayList();
        heads.forEach(head -> head.method_35745(new class_4587(), (pose, path, i, cube) -> {
            for (class_630.class_593 p : cube.field_3649) {
                HeadPolygon polygon = new HeadPolygon(pose, p, rotated, 4);
                float epsilon = 1.0E-5f;
                if (!(Math.abs(polygon.normal.z) > epsilon)) continue;
                facePolygons.add(polygon);
            }
        }));
        heads.forEach(head -> head.method_32085((class_5603)headPoses.get(head)));
        if (facePolygons.isEmpty()) {
            return null;
        }
        facePolygons.sort((p1, p2) -> {
            float p2AverageZ = (p2.vertices[0].comp_3186().z + p2.vertices[1].comp_3186().z + p2.vertices[2].comp_3186().z + p2.vertices[3].comp_3186().z) / 4.0f;
            float p1AverageZ = (p1.vertices[0].comp_3186().z + p1.vertices[1].comp_3186().z + p1.vertices[2].comp_3186().z + p1.vertices[3].comp_3186().z) / 4.0f;
            float comp = Math.signum(p2AverageZ - p1AverageZ);
            if (comp == 0.0f) {
                comp = Math.signum(p2.normal.z - p1.normal.z);
            }
            return (int)comp;
        });
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (HeadPolygon p : facePolygons) {
            for (class_630.class_618 v : p.vertices) {
                minX = Math.min(minX, Math.round(v.comp_3186().x));
                maxX = Math.max(maxX, Math.round(v.comp_3186().x));
                minY = Math.min(minY, Math.round(v.comp_3186().y));
                maxY = Math.max(maxY, Math.round(v.comp_3186().y));
            }
        }
        int headWidth = maxX - minX;
        int headHeight = maxY - minY;
        class_1011 headImage = ImageUtil.getNewBlankImage((headWidth + 1) * 4, (headHeight + 1) * 4);
        try {
            for (HeadPolygon p : facePolygons) {
                MobIconCache.drawPolygonOnImage(p, minX, minY, entityImage, headImage);
            }
            if ((headImage = MobIconCache.cropImage(headImage)) == null) {
                return null;
            }
            headImage = MobIconCache.resizeImage(headImage, 4, rotated);
            MobIconCache.maskImage(headImage);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error creating icon for '{}': {}", (Object)mobLocation, (Object)e);
            return null;
        }
        return headImage;
    }

    private static void drawPolygonOnImage(HeadPolygon polygon, int originX, int originY, class_1011 from, class_1011 to) {
        if (polygon.vertices.length != 4) {
            return;
        }
        int texWidth = from.method_4307();
        int texHeight = from.method_4323();
        float minU = texWidth;
        float maxU = 0.0f;
        float minV = texHeight;
        float maxV = 0.0f;
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (class_630.class_618 vertex : polygon.vertices) {
            minU = Math.min(minU, vertex.comp_3187() * (float)texWidth);
            maxU = Math.max(maxU, vertex.comp_3187() * (float)texWidth);
            minV = Math.min(minV, vertex.comp_3188() * (float)texHeight);
            maxV = Math.max(maxV, vertex.comp_3188() * (float)texHeight);
            minX = Math.min(minX, vertex.comp_3186().x);
            maxX = Math.max(maxX, vertex.comp_3186().x);
            minY = Math.min(minY, vertex.comp_3186().y);
            maxY = Math.max(maxY, vertex.comp_3186().y);
        }
        for (float y = minY; y < maxY; y += 1.0f) {
            for (float x = minX; x < maxX; x += 1.0f) {
                Vector2f uv = MobIconCache.getUVCoordinates(polygon, x, y);
                uv.x = (float)Math.floor(uv.x * (float)texWidth);
                uv.y = (float)Math.floor(uv.y * (float)texHeight);
                if (!(uv.x >= minU) || !(uv.x < maxU) || !(uv.y >= minV) || !(uv.y < maxV)) continue;
                int c = from.method_61940(Math.min(Math.max(0, (int)uv.x), texWidth - 1), Math.min(Math.max(0, (int)uv.y), texHeight - 1));
                if ((c >> 24 & 0xFF) == 255) {
                    to.method_61941(Math.round(x) - originX, Math.round(y) - originY, c);
                    continue;
                }
                if ((c >> 24 & 0xFF) <= 0) continue;
                ((NativeImageAccess)to).blendPixel(Math.round(x) - originX, Math.round(y) - originY, c);
            }
        }
    }

    private static Vector2f getUVCoordinates(HeadPolygon polygon, float x, float y) {
        Vector3f p0 = polygon.vertices[0].comp_3186();
        Vector3f p1 = polygon.vertices[1].comp_3186();
        Vector3f p2 = polygon.vertices[2].comp_3186();
        Vector2f v0 = new Vector2f(p0.x - p2.x, p0.y - p2.y);
        Vector2f v1 = new Vector2f(p1.x - p2.x, p1.y - p2.y);
        Vector2f v2 = new Vector2f(x + 0.5f - p2.x, y + 0.5f - p2.y);
        float den = v0.x * v1.y - v1.x * v0.y;
        float a = (v2.x * v1.y - v1.x * v2.y) / den;
        float b = (v0.x * v2.y - v2.x * v0.y) / den;
        float c = 1.0f - b - a;
        return new Vector2f(a * polygon.vertices[0].comp_3187() + b * polygon.vertices[1].comp_3187() + c * polygon.vertices[2].comp_3187(), a * polygon.vertices[0].comp_3188() + b * polygon.vertices[1].comp_3188() + c * polygon.vertices[2].comp_3188());
    }

    private static class_1011 cropImage(class_1011 image) {
        int width = image.method_4307();
        int height = image.method_4323();
        int left = width;
        int top = height;
        int right = width;
        int bottom = height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = image.method_61940(x, y);
                if ((c >> 24 & 0xFF) <= 0) continue;
                left = Math.min(left, x);
                top = Math.min(top, y);
                right = Math.min(right, width - x - 1);
                bottom = Math.min(bottom, height - y - 1);
            }
        }
        if (left == width || top == height) {
            image.close();
            return null;
        }
        int newWidth = width - left - right;
        int newHeight = height - top - bottom;
        boolean extraLeft = newWidth % 2 == 1;
        boolean extraBottom = newHeight % 2 == 1;
        class_1011 result = new class_1011(newWidth + (extraLeft ? 1 : 0), newHeight + (extraBottom ? 1 : 0), false);
        image.method_47594(result, left, top, 0, 0, newWidth, newHeight, false, false);
        image.close();
        if (extraLeft) {
            result.method_47594(result, newWidth - 1, 0, newWidth, 0, 1, newHeight, false, false);
        }
        if (extraBottom) {
            result.method_47594(result, 0, newHeight - 1, 0, newHeight, newWidth + (extraLeft ? 1 : 0), 1, false, false);
        }
        return result;
    }

    private static class_1011 resizeImage(class_1011 image, int scale, boolean rotated) {
        int width = image.method_4307();
        int height = image.method_4323();
        SizeInfo sizeInfo = MobIconCache.getClosestValidSize(width, height, scale);
        CropInfo crop = new CropInfo(0, 0, 0, 0);
        if (!sizeInfo.exact) {
            List<CropInfo> cropsToTry = MobIconCache.getSizesToTry(image, scale, rotated);
            for (CropInfo c : cropsToTry) {
                SizeInfo size = MobIconCache.getClosestValidSize(width - c.left - c.right, height - c.top - c.bottom, scale);
                if (!size.exact) continue;
                sizeInfo = size;
                crop = c;
                break;
            }
        }
        class_1011 result = ImageUtil.getNewBlankImage(sizeInfo.width, sizeInfo.height);
        float finalScale = Math.min((float)sizeInfo.width / (float)(width - crop.left - crop.right), (float)sizeInfo.height / (float)(height - crop.top - crop.bottom));
        for (int y = 0; y < result.method_4323(); ++y) {
            for (int x = 0; x < result.method_4307(); ++x) {
                int fromX = Math.round((float)x / finalScale) + crop.left;
                int fromY = Math.round((float)y / finalScale) + crop.top;
                if (fromX < 0 || fromX >= width || fromY < 0 || fromY >= height) continue;
                result.method_61941(x, y, image.method_61940(fromX, fromY));
            }
        }
        image.close();
        return result;
    }

    private static SizeInfo getClosestValidSize(int width, int height, int scale) {
        if (width == 16 * scale && height == 16 * scale) {
            return new SizeInfo(16, 16, true);
        }
        boolean portrait = height > width;
        int longest = portrait ? height : width;
        int shortest = portrait ? width : height;
        float ratio = (float)longest / (float)shortest;
        int closestL = 16;
        int closestS = 16;
        float closestDist = Math.abs(ratio - 1.0f);
        boolean exact = false;
        for (int l = 14; l <= 22; ++l) {
            int s = Math.round((float)l / ratio);
            int diag = l * l + s * s;
            if (diag < 390 || diag > 650) continue;
            boolean e = l % (longest / scale) == 0 && s % (shortest / scale) == 0;
            float dist = Math.abs(ratio - (float)l / (float)s);
            if (!e && exact || !e && !(dist < closestDist)) continue;
            closestL = l;
            closestS = s;
            exact = e;
        }
        if (portrait) {
            return new SizeInfo(closestS, closestL, exact);
        }
        return new SizeInfo(closestL, closestS, exact);
    }

    private static List<CropInfo> getSizesToTry(class_1011 image, int scale, boolean rotated) {
        int width = image.method_4307();
        int height = image.method_4323();
        boolean portrait = height > width;
        ArrayList<CropInfo> crops = new ArrayList<CropInfo>();
        for (int y = -1; y < 4; ++y) {
            for (int x = -1; x < 4; ++x) {
                if (x == 0 && y == 0) continue;
                if (rotated) {
                    crops.add(new CropInfo(x < 0 ? scale * x : 0, y < 0 ? scale * y : 0, x > 0 ? scale * x : 0, y > 0 ? scale * y : 0));
                    continue;
                }
                crops.add(new CropInfo(scale * x / 2, scale * y / 2, scale * x / 2, scale * y / 2));
            }
        }
        crops.sort((c1, c2) -> {
            int c1H = c1.left + c1.right;
            int c1V = c1.top + c1.bottom;
            int c2H = c2.left + c2.right;
            int c2V = c2.top + c2.bottom;
            int d = c1H + c1V - c2H - c2V;
            if (d == 0) {
                if (portrait && c1V > c1H) {
                    return -1;
                }
                if (!portrait && c1V < c1H) {
                    return 1;
                }
            }
            return d;
        });
        return crops;
    }

    private static void maskImage(class_1011 image) {
        if (markerMask == null) {
            return;
        }
        int cornerX = markerMask.method_4307() / 2 - image.method_4307() / 2;
        int cornerY = markerMask.method_4323() / 2 - image.method_4323() / 2;
        for (int y = 0; y < image.method_4323(); ++y) {
            for (int x = 0; x < image.method_4307(); ++x) {
                if ((markerMask.method_61940(cornerX + x, cornerY + y) & 0xFF000000) != 0) continue;
                image.method_61941(x, y, 0);
            }
        }
    }

    private static class_1011 generateOutlined(class_1011 image) {
        class_1011 outline = ImageUtil.getNewBlankImage(image.method_4307() + 2, image.method_4323() + 2);
        for (int y = -1; y < image.method_4323() + 1; ++y) {
            for (int x = -1; x < image.method_4307() + 1; ++x) {
                if (!MobIconCache.isOpaque(image, x, y)) {
                    boolean opaque = false;
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 0, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 1, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y + 0);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 1, y + 0);
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y + 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 0, y + 1);
                    boolean bl = opaque = opaque || MobIconCache.isOpaque(image, x + 1, y + 1);
                    if (opaque) {
                        outline.method_61941(x + 1, y + 1, -16777216);
                        continue;
                    }
                }
                if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) continue;
                outline.method_61941(x + 1, y + 1, image.method_61940(x, y));
            }
        }
        return outline;
    }

    private static boolean isOpaque(class_1011 image, int x, int y) {
        if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) {
            return false;
        }
        return (image.method_61940(x, y) & 0xFF000000) != 0;
    }

    private static class IconTexture {
        public class_1043 solid;
        public class_1043 outlined;

        public IconTexture() {
            this.solid = null;
            this.outlined = null;
        }

        public IconTexture(class_1043 solid, class_1043 outlined) {
            this.solid = solid;
            this.outlined = outlined;
        }

        public void remove() {
            if (this.solid != null && ((TextureAccess)this.solid).journeymap$hasImage()) {
                ImageUtil.closeSafely(this.solid);
            }
            if (this.outlined != null && ((TextureAccess)this.outlined).journeymap$hasImage()) {
                ImageUtil.closeSafely(this.outlined);
            }
        }
    }

    private static class HeadPolygon {
        private static final float PIXEL_TO_BLOCK = 0.0625f;
        private static final float BLOCK_TO_PIXEL = 16.0f;
        public final class_630.class_618[] vertices;
        public final Vector3f normal;

        public HeadPolygon(class_4587.class_4665 pose, class_630.class_593 polygon, boolean rotated, int scale) {
            int s = scale / 2;
            this.vertices = (class_630.class_618[])polygon.comp_3184().clone();
            for (int i = 0; i < this.vertices.length; ++i) {
                class_630.class_618 v = this.vertices[i];
                Vector4f pos = pose.method_23761().transform(new Vector4f(v.comp_3186().x * 0.0625f, v.comp_3186().y * 0.0625f, v.comp_3186().z * 0.0625f, 1.0f));
                this.vertices[i] = rotated ? new class_630.class_618((float)(Math.round(pos.z * 16.0f * (float)s) * s), (float)(Math.round(pos.y * 16.0f * (float)s) * s), pos.x * 16.0f * (float)scale, v.comp_3187(), v.comp_3188()) : new class_630.class_618((float)(Math.round(pos.x * 16.0f * (float)s) * s), (float)(Math.round(pos.y * 16.0f * (float)s) * s), pos.z * 16.0f * (float)scale, v.comp_3187(), v.comp_3188());
            }
            Vector3f r1 = new Vector3f();
            Vector3f r2 = new Vector3f();
            this.vertices[0].comp_3186().sub((Vector3fc)this.vertices[1].comp_3186(), r1);
            this.vertices[0].comp_3186().sub((Vector3fc)this.vertices[2].comp_3186(), r2);
            this.normal = r1.cross((Vector3fc)r2).normalize();
        }
    }

    private static class SizeInfo {
        public int width;
        public int height;
        public boolean exact;

        public SizeInfo(int width, int height, boolean exact) {
            this.width = width;
            this.height = height;
            this.exact = exact;
        }
    }

    private static class CropInfo {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public CropInfo(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }
}

