/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.hopper;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import net.caffeinemc.mods.lithium.api.inventory.LithiumInventory;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeEmitter;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import net.caffeinemc.mods.lithium.common.hopper.InventoryHelper;
import net.caffeinemc.mods.lithium.common.hopper.LithiumDoubleStackList;
import net.caffeinemc.mods.lithium.common.hopper.LithiumStackList;
import net.caffeinemc.mods.lithium.mixin.block.hopper.CompoundContainerAccessor;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class LithiumDoubleInventory
extends CompoundContainer
implements LithiumInventory,
InventoryChangeTracker,
InventoryChangeEmitter,
InventoryChangeListener,
ComparatorTracker {
    private final LithiumInventory first;
    private final LithiumInventory second;
    private LithiumStackList doubleStackList;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = null;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryHandlingTypeListeners = null;

    public static LithiumDoubleInventory getLithiumInventory(CompoundContainer doubleInventory) {
        Container vanillaSecond;
        Container vanillaFirst = ((CompoundContainerAccessor)doubleInventory).getFirst();
        if (vanillaFirst != (vanillaSecond = ((CompoundContainerAccessor)doubleInventory).getSecond()) && vanillaFirst instanceof LithiumInventory) {
            LithiumInventory first = (LithiumInventory)vanillaFirst;
            if (vanillaSecond instanceof LithiumInventory) {
                LithiumInventory second = (LithiumInventory)vanillaSecond;
                LithiumDoubleInventory newDoubleInventory = new LithiumDoubleInventory(first, second);
                LithiumDoubleStackList doubleStackList = LithiumDoubleStackList.getOrCreate(newDoubleInventory, InventoryHelper.getLithiumStackList(first), InventoryHelper.getLithiumStackList(second), newDoubleInventory.getMaxStackSize());
                newDoubleInventory.doubleStackList = doubleStackList;
                return doubleStackList.doubleInventory;
            }
        }
        return null;
    }

    private LithiumDoubleInventory(LithiumInventory first, LithiumInventory second) {
        super((Container)first, (Container)second);
        this.first = first;
        this.second = second;
    }

    @Override
    public void lithium$emitContentModified() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null) {
            for (InventoryChangeListener inventoryChangeListener : inventoryChangeListeners) {
                inventoryChangeListener.lithium$handleInventoryContentModified(this);
            }
            inventoryChangeListeners.clear();
        }
    }

    @Override
    public void lithium$emitStackListReplaced() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(inventoryChangeListener -> inventoryChangeListener.handleStackListReplaced(this));
        }
        this.invalidateChangeListening();
    }

    @Override
    public void lithium$emitRemoved() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(listener -> listener.lithium$handleInventoryRemoved(this));
        }
        this.invalidateChangeListening();
    }

    private void invalidateChangeListening() {
        LithiumStackList lithiumStackList;
        if (this.inventoryChangeListeners != null) {
            this.inventoryChangeListeners.clear();
        }
        if ((lithiumStackList = InventoryHelper.getLithiumStackListOrNull(this)) != null) {
            lithiumStackList.removeInventoryModificationCallback(this);
        }
    }

    @Override
    public void lithium$emitFirstComparatorAdded() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null && !inventoryChangeListeners.isEmpty()) {
            inventoryChangeListeners.removeIf(inventoryChangeListener -> inventoryChangeListener.lithium$handleComparatorAdded(this));
        }
    }

    @Override
    public void lithium$forwardContentChangeOnce(InventoryChangeListener inventoryChangeListener, LithiumStackList stackList, InventoryChangeTracker thisTracker) {
        if (this.inventoryChangeListeners == null) {
            this.inventoryChangeListeners = new ReferenceOpenHashSet(1);
        }
        stackList.setInventoryModificationCallback(thisTracker);
        this.inventoryChangeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void lithium$forwardMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = new ReferenceOpenHashSet(1);
            ((InventoryChangeTracker)((Object)this.first)).listenForMajorInventoryChanges(this);
            ((InventoryChangeTracker)((Object)this.second)).listenForMajorInventoryChanges(this);
        }
        this.inventoryHandlingTypeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void lithium$stopForwardingMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners != null) {
            this.inventoryHandlingTypeListeners.remove((Object)inventoryChangeListener);
            if (this.inventoryHandlingTypeListeners.isEmpty()) {
                ((InventoryChangeTracker)((Object)this.first)).stopListenForMajorInventoryChanges(this);
                ((InventoryChangeTracker)((Object)this.second)).stopListenForMajorInventoryChanges(this);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryLithium() {
        return this.doubleStackList;
    }

    @Override
    public void setInventoryLithium(NonNullList<ItemStack> inventory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lithium$handleInventoryContentModified(Container inventory) {
        this.lithium$emitContentModified();
    }

    @Override
    public void lithium$handleInventoryRemoved(Container inventory) {
        this.lithium$emitRemoved();
    }

    @Override
    public boolean lithium$handleComparatorAdded(Container inventory) {
        this.lithium$emitFirstComparatorAdded();
        return this.inventoryChangeListeners.isEmpty();
    }

    @Override
    public void lithium$onComparatorAdded(Direction direction, int offset) {
        throw new UnsupportedOperationException("Call onComparatorAdded(Direction direction, int offset) on the inventory half only!");
    }

    @Override
    public boolean lithium$hasAnyComparatorNearby() {
        return ((ComparatorTracker)((Object)this.first)).lithium$hasAnyComparatorNearby() || ((ComparatorTracker)((Object)this.second)).lithium$hasAnyComparatorNearby();
    }
}

